type sessionLangs = {
  [key: string]: number;
};

type themeKey = "name" | "queryCount" | "startTime" | "time";

type sessionTheme = {
  name: string;
  queryCount: number;
  startTime: number;
  time: number;
};

type sessionMenuActions = {
  [key: string]: number;
};

type searchAction = "clickCount" | "voiceCount" | "keyboardCount";

type sessionCategories = {
  [key: string]: {
    [key: searchAction]: number;
    clickCount: number;
    voiceCount: number;
    keyboardCount: number;
  };
};

type sessionObjects = {
  [key: string]: {
    type: string;
    [key: searctAction]: number;
    clickCount: number;
    voiceCount: number;
    keyboardCount: number;
  };
};

type sessionVideophone = {
  times: number[];
  count: number;
};

type stores = "googlePlay" | "appStore";

interface Session {
  langs: sessionLangs | null; //+
  themes: sessionTheme[] | null; //+
  pathCount: number; //+
  menu?: sessionMenuActions; //+
  categories?: sessionCategories; //+
  objects?: sessionObjects; //+
  videophone?: sessionVideophone; //+
  takemobile?: takemobile; //??????
  // neuroAd?: neuroAd; //???????
  startTime: number;
  endTime: number | null;
  events: sessionEvents;
}

type sessionProps = {
  startLang?: string;
  startTheme?: string;
  idleInterval?: number;
};

type sessionEvents = {
  [key: string]: {
    [key: searchAction]: number;
    clickCount: number;
    voiceCount: number;
    keyboardCount: number;
  };
}

type sessionStatistics = {
  langs: langs;
  themes: themes;
  sessions: sessions;
  menu: menuActions;
  categories: categories;
  objects: objects;
  videophone: videophone;
  takemobile: takemobile;
  events: events;
};