const { app, BrowserWindow, screen } = require('electron');

const createWindow = (size) => {
    try {
        const window = new BrowserWindow({
            webPreferences: {
                nodeIntegration: true,
                contextIsolation: false,
            },
            id: 'main',
            width: size?.width || 1080,
            height: 1000,
            x: 0,
            y: 0,
            frame: false,
            fullScreen: true
        })
        window.loadFile('index.html');

    } catch (error) {
        console.error('[error] Can not create window. Error:', error);
    };
};

app.whenReady().then(() => {
    const mainScreen = screen.getPrimaryDisplay();
    createWindow(mainScreen.size);
});