const { app, BrowserWindow, screen } = require('electron');

app.commandLine.appendSwitch('enable-features', 'WebRTCPipeWireCapturer');
app.commandLine.appendSwitch('ignore-certificate-errors');

const createWindow = (size) => {
    try {
        const window = new BrowserWindow({
            webPreferences: {
                nodeIntegration: true,
                contextIsolation: false,
            },
            id: 'main',
            width: size?.width || 1080,
            height: size?.height || 1920,
            x: 0,
            y: 0,
            // frame: false,
            fullScreen: true,
        });
        window.loadFile('index.html');

        window.webContents.openDevTools();
    } catch (error) {
        console.error('[error] Can not create window. Error:', error);
    }
};

app.whenReady().then(() => {
    const mainScreen = screen.getPrimaryDisplay();
    createWindow(mainScreen.size);
});
