# Модуль видеосвязи #
> Версия: 2.1.5

---

## Описание:
> Модуль предназначен связи двух клиентов по технологии PTP (peer-to-peer) или SIP (session initiation protocol)

## Структура:
* `example` содержит простое `electron` приложение и необходимые файлы для демнострации работы модуля.

## Подключение:
* ### Посмотреть пример работы пакета:
	1. Установить пакет: `npm install @neuro-city/neuro-phone`;
	1. Перейти в директорию запуска примера работы модуля `neuro-phone/client/example`;
	1. Выполнить `npm install`;
	1. Запустить пример: `npm run example`;
* ### Подключить пакет к проекту:
	1. Установить пакет: `npm install @neuro-city/neuro-phone`;
	1. Создать переменную пакета `const neuroPhone = require('@neuro-city/neuro-phone');`;

## Интерфейс:
* ### Команды:
	* **init** - Функция инициализации. Принимает на вход объект со следующими параметрами:
		```
		{
			serverIp: '0.0.0.0', // (обязательный параметр, строка) ip сигнального сервера
			serverPort: '8088', // (обязательный параметр, строка) порт сигнального сервера
			platformId: 'n5v89ekmnitzyu9xzpfc62d8', // (обязательный параметр, строка) id платформы, к которой принадлежим
			platformName: 'Тестовая платформа', // (обязательный параметр, строка) название платформы, к которой принадлежим
			clientType: 'receiver', // (обязательный параметр, строка) тип клиента: receiver(клиент) или provider(оператор)

			//параметры только для оператора:
			//---------------------------------------------
			name: 'John', // (строка) наше отображаемое имя
			//---------------------------------------------

			//параметры только для клиента:
			//---------------------------------------------
			deviceName: 'test-device', // (строка) имя устройства
			camRotate: 'none', // (строка) разворот медиа с камеры устройства. Доступные значение: 'none', 'left', 'right', 'invert'
			camInvertY: true, // (boolean) необходимость отзеркаливать изображение с камеры устройства
			//расположение устройства (клиент) на карте
			floor: 1, // (число) этаж
			positionX: 1590, // (число)
    		positionY: 1925, // (число)
			orientationX: -1, // (число)
    		orientationY: 0, // (число)
			//---------------------------------------------
		}
		```
	* **changePlatform** - changePlatform(platformName, platformId) - функция для изменения платформы, к которой принадлежит оператор. Принимает на вход два параметра: platformName (названиче платформы, строк) и platformId (id платформы, строка);
    * **call** - осуществляет звонок. Принимает параметры:
        1. image - ссылка на изображение, которое увидит колл-центр
	* **declineCall** - осуществляет сброс вызова.
	* **on** - on(event, action) - возвращает `callback` на следующие события:
		- '**error**': информация об ошибках в работе модуля;
		- '**warn**': предупреждения;
		- '**info**': общая информация о работе модуля;
		- 'inited': успешная инициализация, клиент поставлен на обслуживание;
		- 'busy': все операторы заняты;
		- 'call-decline': оператор сбросил вызов;
		- 'wait-number': все операторы заняты, просьба подождать в очереди;
		- 'mute': абонент выключил/включил микрофон;
		- 'hide-video': абонент выключил/включил видео;
		- 'call-not-possible' + data: невозможно совершить вызов, data - причина;
		- 'incoming-stream': приём видеострима собеседника;
		- 'incoming-audio': приём аудиострима собеседника;
		- 'call-ended': завершение вызова;
		В разработке:
		- 'busy-operator-found': подобран занятый оператор;
		- 'update-queue': номер в очереди изменён;
	* **onProviderEvents** - onProviderEvents(event, action) - возвращает `callback` на следующие события оператора:
		- 'accept-call': принят вызов;
		- 'call-ended': вызов завершён;
		- 'stream': принят стрим от клиента стрим, внутри даты события - stream;
		- 'signal-to-provider': входящий вызов;
		- 'receiver-declined-call': клиент сбросил вызов;
	* **acceptConnectionProvider** - acceptConnectionProvider() - функция приёма вызова для оператора;
	* **sendProviderIsBusy** - sendProviderIsBusy() - отправляет на сервер информацию о том, что оператор занят. Может использоваться для сброса вызова.
	* **offProvider** - offProvider() - приостанавливает работу оператора. Возвращает true в случае успешного выполнения.
	* **onProvider** - onProvider() - возобновляет работу, оператор снова может принимать звонки.
	* **toggleMic** - toggleMic() - используется оператором для отключения/включения микрофона в момент разговора (mute). Переводит микрофон в противоположное состояние - отключает, если был включен и наоборот.
	* **toggleVideo** - toggleVideo() - используется оператором для отключения/включения своего видео у клиента. Если видео уже было выключено, вызов функции его включит.
	* **controlMicVolume** - controlMicVolume(volume: number) - используется оператором для регулировки громкости микрофона во время разговора, принимает число от 0 до 1.
* ### Примечание:
	* 
* ### Changelog 
	* v1.2.0:
		1. Добавлена функция changePlatform;
	* v1.2.2:
		1. Stun в urls берётся из переменной (убран хардкод).
	* v1.2.3:
		1. Убран параметр url в iceServers (deprecated).
	* v2.0.0
		1. Добавлен объект providerEmitter для взаимодействия c логикой рендера операторской;
		2. Исправлена опечатка в названии функции setSelfStream (было: setSelfStraem);
		3. Добавлен ряд функций для работы оператора.
	* v2.1.0 
		1. Добавлена функция controlMicVolume.
	* v2.1.1
		1. Исправлена опечатка в названии функции acceptConnectionProvider (было acceptConnectionProvier).
	* v2.1.2
		1. Незначительные фиксы в коде, недостойные упоминания в changelog.
	* v2.1.3
		1. Оператору добавлен счётчик принятых вызовов.
	* v2.1.4
		1. Добавлена задержка при отправке инфо от освободившегося оператора на сервер (внутри метода declineCall). Решает проблему мгновенного получения вызова из очереди и следующих за этим проблем в работе операторской.
	* v2.1.5
		1. Добавлена совместимость со старым сервером для отправки события 'no-free-devices'