# Модуль распознавания лиц #
> Версия: 1.0.14

---

## Описание:
> Модуль предназначен для обнаружения и распознавания лиц

## Структура:
* `example` содержит простое `electron` приложение и необходимые файлы для демнострации работы модуля.

## Подключение:
* ### Посмотреть пример работы пакета:
	1. Установить пакет: `npm install @neuro-city/neuro-id`;
	1. Перейти в директорию запуска примера работы модуля `neuro-id/client/example`;
	1. Выполнить `npm install`;
	1. Запустить пример: `npm run example`;
* ### Подключить пакет к проекту:
	1. Установить пакет: `npm install @neuro-city/neuro-id`;
	1. Создать переменную пакета `const faceID = require('@neuro-city/neuro-id');`;

## Интерфейс:
* ### Команды:
	* **init** - инициализация модуля. Принимает первым необязательным параметром массив объектов со свойствами `name` (строка с Ф.И.О. пользователя) и `descriptors` (массив дескрипторов лица пользователя). Если параметр не задан, будет работать только обнаружение лиц без распознавания. Второй необязательный параметр - качество распознавания лиц (вещественное число от 0 до 1). Чем больше число тем больше вероятности обнаружить лицо на изображении, но шанс ошибки (перепутать лицо) пропорционально возрастает;
	* **calculateDescriptor** - расчёт дескриптора. Принимает обязательный параметр типа `HTMLVideoElement`, `HTMLImageElement` или `HTMLCanvasElement` содержащий фото;
	* **addDescriptor** - добавляет дескриптор пользователя. Первый параметр обязателен и должен содержать массив дескрипторов. Второй прараметр принимается типа `string` и содержит имя пользователя, которому добавляются дескрипторы. Если имя не указано, декрипторы добавятся записи "Тестовый пользователь";
	* **updateDescriptors** - заменяет наборы дескрипторов лиц пользователей для распознавания. Принимает необязательным параметром массив объектов со свойствами `name` (строка с Ф.И.О. пользователя) и `descriptors` (массив дескрипторов лица пользователя). Если параметр не задан, будет работать только обнаружение лиц без распознавания;
	* **findUser** - поиск пользователя по дескриптору. Обязательный параметр набор дескрипторов пользователя типа `Array`. Возвращает строку с именем пользователя или пустую строку;
	* **start** - запуск распознавания лиц из видеоисточника. Первый парамерт обязателен и должен иметь тип `HTMLVideoElement`. Второй параметр - настройки камеры, должен быть объектом со свойствами: rotate: `number` (угол поворота видео), verticalInvert: `boolean` (инверсия изображения сверху вниз), horizontalInvert: `boolean` (инверсия изображения спарава налево). Если настройки камеры не заданы, то используются поумолчанию (без поворотов и инверсий). Третий параметр - задержка перед следующим распознаванием в миллисекундах(по умолчанию - 0);
	* **stop** - остановка сценария распознавания;
	* **on** - возвращает `callback` на следующие события:
		* **data** - информацию о работе модуля;
		* **error** - информацию об ошибках в работе модуля;
		* **ready** - при успешной инициализации модуля после команды `init`. Передаёт строку со списком загруженных моделей;
		* **calculated** - при успешном расчёте набора дескрипторов после команды `calculateDescriptor`. Передаёт набор дескрипторов ввиде массива;
		* **detected** - при успешном распознаваниии лиц. Передаёт объект содержащий в себе:
			* **face** - объект с данными самого близкого к камере лица:
				* **x** - сдвиг рамки обводки лица по оси X;
                * **y** - сдвиг рамки обводки лица по оси Y;
                * **width** - ширина рамки обводки лица;
                * **height** - высота рамки обводки лица;
                * **descriptor** - набор дескрипторов,
                * **name** - именем пользователя, если нашёлся в наборах дескрипторов или пустую строку, если не нашёлся;
			* **faces** - массив с данными лиц, находящихся дальше самого близкого (состоит из объектов `face`);
            * **time** - время затраченное на распознавание лиц;

* ### Примечание:
	* Модуль распознавания лиц работает только в браузере. Работа в NodeJS пока невозможна.

* ### Changelog
	1. Версия 1.0.14:
		1. Добавлен параметр качества распознавания лица;
		1. ТЕстовое фото удаляется после инициализации.
