// pageDesign.js

// Обновляет значение света в интерфейсе
const updateLightValue = () => {
    const slider = document.getElementById('setLightValue');
    const display = document.getElementById('lightValueDisplay');
    display.textContent = slider.value;
};

// Проверяет и валидирует введенный угол
const validateAngle = () => {
    const input = document.getElementById('setAngleValue');
    if (input.value.length > 3) {
        input.value = input.value.slice(0, 3);
    }
    if (input.value > 359) {
        input.value = 359;
    }
    if (input.value < 0) {
        input.value = 0;
    }
};

// Генерирует случайный цвет
const getRandomColor = () => {
    const letters = '0123456789ABCDEF';
    let color = '#';
    for (let i = 0; i < 6; i++) {
        color += letters[Math.floor(Math.random() * 16)];
    }
    return color;
};

// Добавляет обработчик события для изменения цвета фона кнопок при наведении
document.querySelectorAll('button').forEach(button => {
    button.addEventListener('mouseover', function() {
        this.style.backgroundColor = getRandomColor();
    });
});

// Функция для валидации целочисленных значений
const validateInteger = (input) => {
    input.value = input.value.replace(/[^0-9]/g, '');
};

// Обработчик события для поля ввода интервала видео
document.getElementById('videoIntervalInput').addEventListener('input', () => {
    validateInteger(document.getElementById('videoIntervalInput'));
});