const handleMethod = (client, data) => {
    switch (data.methodName) {
        case 'calibrate':
            calibrate(client, data.holoFan, data.config, data.args);
            break;
        case 'playVideoFromPlaylist':
            playVideoFromPlaylist(client, data.holoFan, data.config, data.args);
            break;
        case 'arrayVideoFiles':
            arrayVideoFiles(client, data.holoFan, data.config, data.args.filledPumps);
            break;
        default:
            client.emit('error', `Неизвестное сообщение: ${data}`);
    }
};

// Метод калибровки
const calibrate = (client, holoFan, config, data) => {
    client.sendCommand('setAngle', data.calibrate.angle);
    client.sendCommand('setMotorSpeed', data.calibrate.speed);
    client.sendCommand('setLight', data.calibrate.brightness);
    client.emit('data', 'Калибровка завершена с настройками: ' + JSON.stringify(data.calibrate));
    setTimeout(() => {
        client.sendCommand('usePlayList', data.indexIdlePlayList);
    }, 2000);
};

const playVideoFromPlaylist = (client, holoFan, config, data) => {
    client.sendCommand('playVideoFromPlaylist', data);
};


let isPlaying = false;
let currentArrayPlaybackId = null; // Уникальный ID для отслеживания текущего воспроизведения
const arrayVideoFiles = (client, holoFan, config, data) => {
    // console.log("Входные данные вызова arrayVideoFiles:", data); // Логируем входные данные
    client.emit('data', `Входные данные вызова arrayVideoFiles: ${data}`);

    stopCurrentPlayback(client);

    if (data.length === 0) {
        // console.log("Массив данных пуст. Запуск idle-плейлиста:", config.indexIdlePlayList || 0);
        client.sendCommand('usePlayList', config.indexIdlePlayList || 0); // Запуск idle-плейлиста
        return;
    }

    // Создаем уникальный идентификатор для каждого вызова
    const playbackId = Symbol('playbackId');
    currentArrayPlaybackId = playbackId; // Сохраняем текущий ID

    const { numberSystem, numberHoloFanInSystem, playbackDuration, intervalDuration } = initializeParameters(holoFan);
    let currentIndex = calculateStartingIndex(data, numberHoloFanInSystem);

    playArrayVideoFiles(client, data, currentIndex, numberSystem, playbackDuration, intervalDuration, config, playbackId);
};

// Остановка текущего процесса воспроизведения
const stopCurrentPlayback = (client) => {
    if (isPlaying) {
        clearTimers(client);
        isPlaying = false;
    }
    currentArrayPlaybackId = null; // Сбрасываем ID текущего воспроизведения
};

// Очистка таймеров и интервалов
const clearTimers = (client) => {
    if (client.currentTimeout) {
        // console.log("Очистка текущего таймаута:", client.currentTimeout);
        clearTimeout(client.currentTimeout);
    }
    if (client.controlInterval) {
        // console.log("Очистка текущего интервала:", client.controlInterval);
        clearInterval(client.controlInterval);
    }
    // console.log(`Значение client.currentTimeout: ${client.currentTimeout}`);
    // console.log(`Значение client.controlInterval: ${client.controlInterval}`);
};

// Инициализация параметров
const initializeParameters = (holoFan) => {
    const numberSystem = holoFan.numberSystem;
    const numberHoloFanInSystem = holoFan.numberHoloFanInSystem;
    const playbackDuration = holoFan.durationPlaybackElementsArrayVideoFiles - 1;
    const intervalDuration = holoFan.durationBetweenArraysStarts || 5;

    // console.log("Параметры инициализированы:", {
    //     numberSystem,
    //     numberHoloFanInSystem,
    //     playbackDuration,
    //     intervalDuration
    // });

    return { numberSystem, numberHoloFanInSystem, playbackDuration, intervalDuration };
};

// Вычисление начального индекса
const calculateStartingIndex = (data, numberHoloFanInSystem) => {
    const currentIndex = (numberHoloFanInSystem <= data.length) ? 
                        (numberHoloFanInSystem - 1) % data.length : 
                        numberHoloFanInSystem - 1;
    // console.log("Начальный индекс воспроизведения:", currentIndex);
    return currentIndex;
};

// Основная функция для воспроизведения массива видеофайлов
const playArrayVideoFiles = (client, data, currentIndex, numberSystem, playbackDuration, intervalDuration, config, playbackId) => {
    let playingIdle = false;
    let firstPlaybackOfArrayAfterIdle = true;

    const playNextVideo = () => {
        // Проверяем, является ли текущий вызов актуальным
        if (currentArrayPlaybackId !== playbackId) {
            // Если вызов уже не актуален, останавливаем воспроизведение
            // console.log('Вызов неактуальный. Останавливаем воспроизведение', data);
            client.emit('data', `Вызов неактуальный. Останавливаем воспроизведение: ${data}`);
            return;
        }

        if (!isPlaying) {
            // console.log("Начало воспроизведения. Устанавливаем флаг isPlaying в true.");
            isPlaying = true;
        }

        // console.log(`Data: ${data}, Запуск playNextVideo. Текущий индекс: ${currentIndex}`);

        if (currentIndex >= data.length && currentIndex >= numberSystem) {
            // console.log("Индекс превысил длину массива и количество систем. Сбрасываем индекс на 0.");
            currentIndex = 0;
        }

        if (currentIndex >= data.length && currentIndex < numberSystem) {
            if (!playingIdle) {
                // console.log("Воспроизведение idle-плейлиста:", client.config.indexIdlePlayList || 0);
                client.sendCommand('usePlayList', client.config.indexIdlePlayList || 0);
                playingIdle = true;
                firstPlaybackOfArrayAfterIdle = true;  // Переключаем флаг на true после idle
            }
        } else {
            playRegularVideo(client, data, currentIndex, config, firstPlaybackOfArrayAfterIdle);
            firstPlaybackOfArrayAfterIdle = false;
            playingIdle = false;
        }

        currentIndex++;
        // console.log("Установка таймаута для следующего воспроизведения через", playbackDuration, "секунд.");
        client.currentTimeout = setTimeout(playNextVideo, playbackDuration * 1000);
    };

    waitForControlPointAndPlay(client, intervalDuration, playNextVideo);
};

// Воспроизведение обычного видео
const playRegularVideo = (client, data, currentIndex, config, firstPlaybackOfArrayAfterIdle) => {
    const videoIndex = data[currentIndex];
    // console.log("Воспроизведение видео с номером:", videoIndex);
    // console.log('Значение firstPlaybackOfArrayAfterIdle равно:', firstPlaybackOfArrayAfterIdle);
    
    if (firstPlaybackOfArrayAfterIdle) {
        // console.log("Первое воспроизведение после idle. Команда playVideoFromPlaylist.", videoIndex);
        client.sendCommand('playVideoFromPlaylist', { playlistIndex: config.indexArrayVideoFilesMetodPlayList, videoIndex });
    } else {
        // console.log("Команда playVideo.");
        client.sendCommand('playVideo', videoIndex);
    }
};

const waitForControlPointAndPlay = (client, intervalDuration, playNextVideo) => {
    const waitTime = calculateWaitTimeToNextControlPoint(intervalDuration) * 1000;
    // console.log("Ожидание до следующей контрольной точки:", waitTime / 1000, "секунд.");
    let hasPlayed = false; // Флаг для отслеживания, было ли воспроизведение
    
    // Интервал для проверки контрольной точки
    client.controlInterval = setInterval(() => {
        if (!hasPlayed && isControlPoint(intervalDuration)) {
            // console.log("Контрольная точка достигнута. Запуск воспроизведения.");
            hasPlayed = true; // Воспроизведение выполнено
            clearInterval(client.controlInterval);
            playNextVideo();
        }
    }, 1000);
    
    // Таймаут на ближайшую контрольную точку
    setTimeout(() => {
        if (!hasPlayed) {
            // console.log("Таймаут завершен. Запуск воспроизведения.");
            hasPlayed = true;
            clearInterval(client.controlInterval);
            playNextVideo();
        }
    }, waitTime);
}

// Вычисление времени до следующей контрольной точки
const calculateWaitTimeToNextControlPoint = (intervalDuration) => {
    const now = new Date();
    const secondsSinceMidnight = now.getHours() * 3600 + now.getMinutes() * 60 + now.getSeconds();
    const waitTime = intervalDuration - (secondsSinceMidnight % intervalDuration);
    // console.log("Время до следующей контрольной точки:", waitTime, "секунд.");
    return waitTime;
};

// Проверка, является ли текущее время контрольной точкой
const isControlPoint = (intervalDuration) => {
    const now = new Date();
    const secondsSinceMidnight = now.getHours() * 3600 + now.getMinutes() * 60 + now.getSeconds();
    const isControl = secondsSinceMidnight % intervalDuration === 0;
    // console.log("Проверка контрольной точки. Результат:", isControl);
    return isControl;
};


module.exports = { handleMethod };

