//_____________________________________________________
//Запуск пакета управления голографическим вентилятором
const neuroAirClient = require('../index');
const config = require('../configs/config.json')

let holoFan;
const holoFanConnect = () => {
    
    if (config.holoFan.value.enable.value) {
        try {
            const ventilator = {
                id: config?.holoFan?.value?.id?.value,
                host: config?.holoFan?.value?.host?.value,
                port: config?.holoFan?.value?.port?.value,
                nameHoloFan: config?.holoFan?.value?.nameHoloFan?.value,
                keyHoloFan: config?.holoFan?.value?.keyHoloFan?.value,
                numberSystem: config?.holoFan?.value?.numberSystem?.value,
                numberHoloFanInSystem: config?.holoFan?.value?.numberHoloFanInSystem?.value,
                durationPlaybackElementsArrayVideoFiles: config?.holoFan?.value?.durationPlaybackElementsArrayVideoFiles?.value,
                durationBetweenArraysStarts: config?.holoFan?.value?.durationBetweenArraysStarts?.value,
                numberReconnectionsToHoloFAn: config?.holoFan?.value?.numberReconnectionsToHoloFAn?.value,
                reconnectionIntervalToHoloFan: config?.holoFan?.value?.reconnectionIntervalToHoloFan?.value,
                wiFicheckInterval: config?.holoFan?.value?.wiFicheckInterval?.value,
                angle: config?.holoFan?.value?.calibration?.value?.angle?.value,
                speed: config?.holoFan?.value?.calibration?.value?.speed?.value,
                brightness: config?.holoFan?.value?.calibration?.value?.brightness?.value,
                wsServerPath: config?.holoFan?.value?.wsServerPath?.value, // для клиентского приложения ./node_modules/@neuro-city/neuro-air/wsServer; для примера работы пакета ./wsServer
                performDeployment: config?.holoFan?.value?.performDeployment?.value
            }
            console.log('[holofan] Настройки голографического вентилятора успешно получены: ', ventilator);
            
            
            holoFan = new neuroAirClient(ventilator);
    
            holoFan.on('ready', (data) => {
                console.log(`[holofan]: ${data}`);
                holoFan.connectToHoloFan();
            });
            // Событие осуществленния подключения
            holoFan.on('connected', (data) => { 
                console.log(`[holofan]: ${data}`); 
            });
            // Событие отключения 
            holoFan.on('disconnected', (data) => {
                console.log(`[holofan]: ${data}`);
            });
            // Событие ошибки
            holoFan.on('error', (error) => {
                console.log('[holofan] Ошибка:' + error);
            });
            // Событие сообщения
            holoFan.on('message', (message) => {
                console.log(`[holofan]: ${message}`);
            });
            // Событие деплоя
            holoFan.on('deploy', (message) => {
                console.log(`[holofan]: ${message}`);
            });
            // Событие данных
            holoFan.on('data', (data) => { 
                console.log(`[holofan]: ${data}`);
            });
            // Событие изменения статуса
            holoFan.on('status-changed', (status) => {
                console.log('[holofan]', status);
            });
        } catch (error) {
            console.error('[holofan] В работе голографического вентилятора возникла ошибка:' + error)
        }
    } else {
        console.warn('[holofan] Подключение к модулу HoloFan отключено в конфиге')
    }
};

holoFanConnect();
setTimeout(() => {
    holoFan.callCommand("arrayVideoFiles", { filledPumps: [2] });
}, 15000);

setTimeout(() => {
    holoFan.callCommand("arrayVideoFiles", { filledPumps: [1,4,5,6,10,11,12] });
}, 16000);

setTimeout(() => {
    holoFan.callCommand("arrayVideoFiles", { filledPumps: [] });
}, 20000);

setTimeout(() => {
    holoFan.callCommand("arrayVideoFiles", { filledPumps: [5,7] });
}, 30000);

setTimeout(() => {
    holoFan.callCommand("arrayVideoFiles", { filledPumps: [1,2,7] });
}, 31000);

setTimeout(() => {
    holoFan.callCommand("arrayVideoFiles", { filledPumps: [1,7,9,10] });
}, 33000);

setTimeout(() => {
    holoFan.callCommand("arrayVideoFiles", { filledPumps: [] });
}, 280000);

setTimeout(() => {
    holoFan.callCommand("arrayVideoFiles", { filledPumps: [12] });
}, 290000);
