const { execSync } = require('child_process');
const fs = require('fs');
const path = require('path');
const os = require('os');

// Метод для проверки и установки необходимых инструментов
const checkAndInstallDependencies = (client, holoFan) => {
    if (os.platform() === 'linux' && holoFan.performDeployment) {
        // Проверка Maven
        try {
            const mavenVersion = execSync('mvn -version').toString();
            if (!mavenVersion.includes('Apache Maven')) {
                client.emit('deploy', 'Maven не найден. Установка Maven...')
                installMaven(client);
            } else {
                client.emit('deploy', 'Maven уже установлен.')
            }
        } catch (error) {
            client.emit('deploy', 'Maven не установлен. Установка Maven...')
            installMaven(client);
        }

        // Проверка OpenJDK
        try {
            const javaVersion = execSync('java -version 2>&1').toString();
            if (!javaVersion.includes('openjdk version "17')) {
                client.emit('deploy', 'OpenJDK 17 не найден. Установка OpenJDK...')
                installOpenJDK(client);
            } else {
                client.emit('deploy', 'OpenJDK 17 уже установлен.')
            }
        } catch (error) {
            client.emit('deploy', 'Java не установлена. Установка OpenJDK...')
            installOpenJDK(client);
        }

        // Проверка FFmpeg
        try {
            const ffmpegVersion = execSync('ffmpeg -version').toString();
            if (!ffmpegVersion.includes('ffmpeg version')) {
                client.emit('deploy', 'FFmpeg не найден. Установка FFmpeg...')
                installFFmpeg(client);
            } else {
                client.emit('deploy', 'FFmpeg уже установлен.')
            }
        } catch (error) {
            client.emit('deploy', 'FFmpeg не установлен. Установка FFmpeg...')
            installFFmpeg(client);
        }
    }
}

// Методы установки зависимостей
const installMaven = (client) => {
    execSync(`
        wget https://archive.apache.org/dist/maven/maven-3/3.6.3/binaries/apache-maven-3.6.3-bin.tar.gz &&
        sudo tar xf apache-maven-3.6.3-bin.tar.gz -C /opt &&
        sudo ln -s /opt/apache-maven-3.6.3/bin/mvn /usr/bin/mvn
    `);
    client.emit('deploy', 'Maven установлен.')
}

const installOpenJDK = (client) => {
    execSync('sudo apt-get install -y openjdk-17-jdk');
    client.emit('deploy', 'OpenJDK 17 установлен.')
}

const installFFmpeg = (client) => {
    execSync('sudo apt-get install -y ffmpeg');
    client.emit('deploy', 'FFmpeg установлен.')
}

module.exports = { checkAndInstallDependencies };