const { exec } = require('child_process');
const os = require('os');
const iconv = require('iconv-lite');
let settings = null;

// Метод для проверки доступности Wi-Fi и подключения
const initWiFiCheck = (client, data, config) => {
    settings = config
    if (checkHoloFanVentilator(client, data)) {
        setInterval(() => {
            checkWiFiCapability(client, (isCapable) => {
                if (isCapable) {
                    client.holoFan.statusWiFI = true;
                    connectToWiFi(client, client.holoFan, (isWiFi) => {
                        if (isWiFi) {
                            client.holoFan.connectedWiFi = true;
                            // Дополнительные действия, если подключено
                        } else {
                            client.emit('error', 'Не удалось подключиться к Wi-Fi голографического вентилятора');
                            client.holoFan.connectedWiFi = false;
                        }
                    });
                } else {
                    client.emit('error', 'WiFi не доступен на этом устройстве');
                    client.holoFan.statusWiFI = false;
                }
            });
        }, settings.wiFicheckInterval * 1000); // Интервал для повторной проверки
    }
};

const checkHoloFanVentilator = (client, data) => {
    if (!data.id || !data.host || !data.port || !data.nameHoloFan || !data.keyHoloFan || !data.numberHoloFanInSystem) {
        client.emit('error', `Неверные данные для HoloFan ventilator: ${JSON.stringify(data)}`);
        return false;
    }
    client.emit('ready', `Действительные данные ventilator HoloFan. id: ${data.id}, Name: ${data.nameHoloFan}`);
    return true;
};

const checkWiFiCapability = (client, callback) => {
    let retries = 0;

    const attemptCheck = () => {
        if (os.platform() === 'win32') {
            exec('chcp 65001 | netsh wlan show interfaces', { encoding: 'buffer' }, (error, stdout, stderr) => {
                const decodedStdout = iconv.decode(stdout, 'utf8');
                const decodedStderr = iconv.decode(stderr, 'utf8');

                if (error || stderr.length) {
                    client.emit('error', `Ошибка проверки WiFi интерфейса: ${error.message || decodedStderr}`);
                    retries++;
                    if (retries < settings.maxRetries_checkWiFiCapability) {
                        client.emit('data', `Повторная попытка проверки WiFi через ${settings.retryInterval_checkWiFiCapability} секунд...`);
                        client.checkWiFiCapabilityTimer = setTimeout(attemptCheck, settings.retryInterval_checkWiFiCapability * 1000);
                    } else {
                        client.emit('error', 'Достигнуто максимальное количество повторных попыток. WiFi не доступен.');
                        callback(false);
                    }
                    return;
                }
                const isWiFiCapable = /State\s*:\s*(connected|disconnected)/i.test(decodedStdout) || /Состояние\s*:\s*(включен|выключен)/i.test(decodedStdout);
                callback(isWiFiCapable);
            });
        } else if (os.platform() === 'linux') {
            exec('nmcli device status', (error, stdout, stderr) => {
                if (error || stderr) {
                    client.emit('error', `Ошибка проверки WiFi интерфейса: ${error.message || stderr}`);
                    retries++;
                    if (retries < settings.maxRetries_checkWiFiCapability) {
                        client.emit('data', `Повторная попытка проверки WiFi через ${settings.retryInterval_checkWiFiCapability} секунд...`);
                        client.checkWiFiCapabilityTimer = setTimeout(attemptCheck, settings.retryInterval_checkWiFiCapability * 1000);
                    } else {
                        client.emit('error', 'Достигнуто максимальное количество повторных попыток. WiFi не доступен.');
                        callback(false);
                    }
                    return;
                }
                const isWiFiCapable = /wifi|connected/i.test(stdout);
                callback(isWiFiCapable);
            });
        } else {
            client.emit('error', 'Неподдерживаемая операционная система');
            callback(false);
        }
    };

    attemptCheck();
};

const connectToWiFi = (client, ventilator, callback) => {
    const ssid = ventilator.nameHoloFan;
    const password = ventilator.keyHoloFan;
    const retryInterval = 10000;
    let retries = 0;

    const attemptConnection = () => {
        if (os.platform() === 'win32') {
            exec('netsh wlan show interfaces', (error, stdout, stderr) => {
                if (error || stderr) {
                    client.emit('error', `Ошибка проверки текущего подключения: ${error.message || stderr}`);
                    return;
                }

                const currentConnectionMatch = stdout.match(/SSID\s*:\s*(.+)\r?\n/);
                const currentSSID = currentConnectionMatch ? currentConnectionMatch[1] : null;

                if (currentSSID && currentSSID !== ssid) {
                    exec('netsh wlan disconnect', (disconnectError, disconnectStdout, disconnectStderr) => {
                        if (disconnectError || disconnectStderr) {
                            client.emit('error', `Ошибка отключения от текущего WiFi: ${disconnectError.message || disconnectStderr}`);
                            callback(false);
                            return;
                        }
                        client.emit('data', 'Отключено от текущего WiFi. Попытка подключения к целевой сети...');
                        connectToTargetWiFi();
                    });
                } else {
                    connectToTargetWiFi();
                }
            });

            const connectToTargetWiFi = () => {
                const connectCommand = `netsh wlan connect name="${ssid}"`;
                exec(connectCommand, (error, stdout, stderr) => {
                    if (error || stderr) {
                        client.emit('error', `Ошибка подключения к WiFi голографического вентилятора: ${error.message || stderr}`);
                        retries++;
                        if (retries < settings.maxRetries_connectToWiFi) {
                            client.emit('data', `Повторная попытка подключения к WiFi голографического вентилятора через ${settings.retryInterval_connectToWiFi} секунд...`);
                            client.connectToWiFiTimer = setTimeout(attemptConnection, settings.retryInterval_connectToWiFi * 1000);
                        } else {
                            client.emit('error', 'Достигнуто максимальное количество повторных попыток. Не удалось подключиться к Wi-Fi голографического вентилятора.');
                            callback(false);
                        }
                        return;
                    }
                    callback(true);
                });
            };
        } else if (os.platform() === 'linux') {
            exec(`sudo nmcli dev wifi connect "${ssid}" password "${password}"`, (error, stdout, stderr) => {
                if (error || stderr) {
                    client.emit('error', `Ошибка подключения к WiFi голографического вентилятора: ${error.message || stderr}`);
                    retries++;
                    if (retries < settings.maxRetries_connectToWiFi) {
                        client.emit('data', `Повторная попытка подключения к WiFi голографического вентилятора через ${settings.retryInterval_connectToWiFi} секунд...`);
                        client.connectToWiFiTimer = setTimeout(attemptConnection, settings.retryInterval_connectToWiFi * 1000);
                    } else {
                        client.emit('error', 'Достигнуто максимальное количество повторных попыток. Не удалось подключиться к Wi-Fi голографического вентилятора.');
                        callback(false);
                    }
                    return;
                }
                callback(true);
            });
        } else {
            client.emit('error', 'Неподдерживаемая операционная система');
            callback(false);
        }
    };

    attemptConnection();
};

module.exports = { initWiFiCheck };