# Модуль NeuroAir #

> Версия: 1.0.4

---

## Описание:

> NeuroAir - проект управления голографическими вентиляторами производителя Dsee Lab Hologram. Голографический вентилятор это экран, который представляет собой устройство отображения, которое использует технический принцип сохранения видения (POV) (остаточное изображение движущихся объектов) для достижения эффекта трехмерного голографического улучшения зрения, пневматической подвески, эффекта голографического стереоизображения путем вращения изображения со сверхвысокой плотностью. Данное устройство является периферийным девайсом дройда. NeuroAir позволяет клиентскому приложению дроида в автоматическом режиме управлять голографическим вентилятором, а именно: запускать и останавливать, воспроизводить необходимые плейлисты и файлы, пауза и возобновление воспроизведения, загрузка, удаление и очистка ресурсов. чтение списка воспроизведения устройства, чтение состояния устройства.  Модуль NeuroAir клиентского приложения осуществляет передачу команд посредством специального ПО, которое представляет собой SDK. Он написан на языке Java и взаимодействует в локальной сети через Socket. Клиентский дройд соединяется с голографическим вентилятором по Wi-FI.  

## Подключение:

### Подключение устройства Голографический вентилятор Dsee Lab:

1. Установить голографический вентилятор вблизи дроида. Обеспечить питание. 
2. Убедиться, что на дроиде доступен Wi-Fi. 
3. Осуществить первичное подключение дроида к голографическому вентилятору по Wi-Fi, указав его имя и пароль

### Посмотреть пример работы модуля:

1. Установите пакет `npm install @neuro-city/neuro-air`
2. Перейдите в директорию с примером работы: `cd ./node_modules/@neuro-city/neuro-air/example`
3. В `./node_modules/@neuro-city/neuro-air/configs/config.json` задать имя голографического вентилятора (SSID WiFi) и пароль голографического вентилятора (Key WiFi)
4. Запустите пример: `node index.js`

### Подключить пакет к проекту:

1. Установить пакет: `npm install @neuro-city/neuro-air`
2. Создайте переменную для использования модуля: `const neuroAirClient = require('@neuro-city/neuro-air)`
3. Добавить `./node_modules/@neuro-city/neuro-air/configs/config.json` в app-config проекта 

**Примечание:**для работы пакета необходимо установить JDK 17 и Maven для запуска пакета, а также установить ffmpeg для возможности загрузки файлов на голографический вентилятор

### Перечень функций пакета:

____________________________

## Интерфейс:
* ### Инициализация пакета:
    * В самом начале работы необходимо вызвать класс пакета **neuroAirClient(ventilator)**, который осуществит инициализацию всех данных `ventilator`, осуществит проверку необходимых компонентов среды запуска, проверит доступность Wi-Fi на дроиде и осуществит подключение к голографическому вентилятору. 

    * Объект `ventilator` принимает данные, которые определенны в `./node_modules/@neuro-city/neuro-air/configs/config.json`
* ### Команды:
    * **connectToHoloFan()** - функция необходима для осуществления запуска локального сервера, на котором вертится SDK для взаимодействия с глографическим вентилятором. Далее происходит подключение к локальному серверу по webSocket. После успешного подключения происходит отправка команды на голографический вентилятор. 

    * **callCommand(command, data = {})** - функция является своего рода мостиком между дроидом и голографическим вентилятором. Она представляет собой команду для вызова методов управления. Она принимает два параметра command и data.

        * `command`: строковое значение, которое служит для вызова определенного кейса с набором команд для вызова методов управления голографическим вентилятором. 

        * `data`: объект, который обычно содержит в себе аргументы являющиеся индексами или названиями видеофайлов воспроизведения.
        
        Список доступных команд: 
        1. `playVideoFromPlaylist` - воспроизведение видео из плейлиста. 

        2. `arrayVideoFiles` -  воспроизведение массива видеофайлов. Аргументом `data` необходимо передать объект с ключом `filledPumps`, который представляет собой массив. В массив передаем названия видеофайлов для воспроизведения. При пустом массиве будет воспроизводиться сценарий ждущего режима(idle).
          Пример: 
          ```javascript
          holoFan.callCommand("arrayVideoFiles", { filledPumps: [1,2,3] });
           или
          holoFan.callCommand("arrayVideoFiles", { filledPumps: [] });
          ``` 
* ### Примечание: 

    #### Описание работы голографического вентилятора:

    После запуска дроида и клиентского приложения происходит запуск голографического вентилятора. Далее запуск пакета управления из клиентского приложения. Происходит проверка подключение к Wi-Fi голографического вентилятора. После этого происходит калибровка, которая настраивает:

    * `angle` - угол отображения изображения на голографическом вентиляторе. Принимает значения от 0 до 359 градусов.

    * `speed` - скорость вращения от голографического вентилятора. Принимает значения от 1 до 3.
    * `brightness` - яркость светодиодов на лопастях голографического вентилятора. Принимает значения от 0 до 15.

    После калибровки пакет будет отправлять голографическому вентилятору команды от клиентского приложения.

    #### Инструкция по настройке среды:
    
    Для работы пакета необходимо установить JDK 17 и Maven  для запуска пакета, а также установить ffmpeg для возможности загрузки файлов на голографический вентилятор.

    * **Linux:**

    1. Для установки maven необходимо в терминал ввести команды:
    `wget https://archive.apache.org/dist/maven/maven-3/3.6.3/binaries/apache-maven-3.6.3-bin.tar.gz`
    `sudo tar xf apache-maven-3.6.3-bin.tar.gz -C /opt`
    `sudo ln -s /opt/apache-maven-3.6.3/bin/mvn /usr/bin/mvn`

    2. Для установки JDK необходимо в терминале ввести команду:
    `sudo apt-get install -y openjdk-17-jdk`

    3. Для установки ffmpeg необходимо в терминале ввести команду:
    `sudo apt-get install -y ffmpeg`

    * **Windows:**

    1. Для установки maven:

        * Перейдите на официальный сайт Apache Maven
        * Скачайте последнюю версию Maven (обычно это архив .zip)
        * Распакуйте архив в удобное для вас место (например, C:\Program Files\Maven)
        * Настройте переменные среды:
            Откройте "Система" → "Дополнительные параметры системы" → "Переменные среды". В разделе "Системные переменные" найдите переменную PATH и добавьте путь к папке bin внутри распакованного архива Maven (например, C:\Program Files\Maven\bin). Создайте новую системную переменную с именем MAVEN_HOME и укажите путь к папке Maven.

    2. Для установки JDK:

        * Перейдите на официальный сайт AdoptOpenJDK
        * Выберите версию JDK 17
        * Скачайте установочный файл (MSI Installer) для Windows
        * Запустите установщик и следуйте инструкциям. Установщик автоматически добавит Java в системную переменную PATH


    #### Пример подключения пакета к клиентскому приложению:
    ```javascript
    let holoFan;
    const holoFanConnect = () => {
        
        if (config.holoFan.value.enable.value) {
            try {
                const ventilator = {
                    id: config?.holoFan?.id,
                    host: config?.holoFan?host,
                    port: config?.holoFan?.port,
                    nameHoloFan: config?.holoFan?.nameHoloFan,
                    keyHoloFan: config?.holoFan?.keyHoloFan,
                    numberSystem: config?.holoFan?.numberSystem,
                    numberHoloFanInSystem: config?.holoFan?.numberHoloFanInSystem,
                    durationPlaybackElementsArrayVideoFiles: config?.holoFan?.durationPlaybackElementsArrayVideoFiles,
                    durationBetweenArraysStarts: config?.holoFan?.durationBetweenArraysStarts,
                    numberReconnectionsToHoloFAn: config?.holoFan?.numberReconnectionsToHoloFAn,
                    reconnectionIntervalToHoloFan: config?.holoFan?.reconnectionIntervalToHoloFan,
                    wiFicheckInterval: config?.holoFan?.wiFicheckInterval,
                    angle: config?.holoFan?.value?.calibration?.angle,
                    speed: config?.holoFan?.value?.calibration?.speed,
                    brightness: config?.holoFan?.value?.calibration?.brightness,
                    wsServerPath: config?.holoFan?.value?.wsServerPath?.value, // для клиентского приложения ./node_modules/@neuro-city/neuro-air/wsServer; для примера работы пакета ../wsServer
                    performDeployment: config?.holoFan?.value?.performDeployment?.value
                }
                log.info('[holofan] Настройки голографического вентилятора успешно получены: ', ventilator);
                
                
                holoFan = new neuroAirClient(ventilator);
        
                holoFan.on('ready', (data) => {
                    console.log(`[holofan]: ${data}`);
                    holoFan.connectToHoloFan();
                });
                // Событие осуществленния подключения
                holoFan.on('connected', (data) => { 
                    console.log(`[holofan]: ${data}`); 
                });
                // Событие отключения 
                holoFan.on('disconnected', (data) => {
                    console.log(`[holofan]: ${data}`);
                });
                // Событие ошибки
                holoFan.on('error', (error) => {
                    console.log('[holofan] Ошибка:' + error);
                });
                // Событие сообщения
                holoFan.on('message', (message) => {
                    console.log(`[holofan]: ${message}`);
                });
                // Событие деплоя
                holoFan.on('deploy', (message) => {
                    console.log(`[holofan]: ${message}`);
                });
                // Событие данных
                holoFan.on('data', (data) => { 
                    console.log(`[holofan]: ${data}`);
                });
                // Событие изменения статуса
                holoFan.on('status-changed', (status) => {
                    console.log('[holofan]', status);
                });
            } catch (error) {
                log.error('[holofan] В работе голографического вентилятора возникла ошибка:' + error)
            }
        } else {
            console.warn('[holofan] Подключение к модулу HoloFan отключено в конфиге')
        }
    };
```


