const {app} = require('electron');
const log = require('electron-log');

const reboot = require('./reboot');

// const fs =require('fs');

module.exports = function () {
    const handleError = function (msg, error) {
        log.error(msg, error);

        log.error('ERROR CODE:',error.code);

        if (error.code === 'EROFS') {
            reboot.reboot();
        } else {
            // reboot.roskomnadzor()
        }
    };

    if (process.type === 'renderer') {
        window.addEventListener('error', event => {
            event.preventDefault();
            handleError('Unhandled Error', event.error);
        });

        window.addEventListener('unhandledrejection', event => {
            event.preventDefault();
            handleError('Unhandled Promise Rejection', event.reason);
        });
    } else {
        process.on('uncaughtException', error => {
            handleError('Unhandled Error', error);
        });

        process.on('unhandledRejection', error => {
            handleError('Unhandled Promise Rejection', error);
        });
    }

    // setTimeout(() => {
        // Promise.reject();
    //     fs.readFileSync('/home/123.json');
    //     // fs.writeFileSync('/media/user/3EEA-2205/123.json');
    // }, 5000);
    

}
