const moment = require('moment');
const log = require('electron-log');

const getAllowDays = require('./get-allow-days');
const getNextRunDatetime = require('./get-next-run-datetime');

module.exports = (task) => {
    try {
        const re = {};
        re.startAt = moment(task.schedule_time_start, 'HH:mm');
        re.diff = Math.round(re.startAt.diff(moment()) / 1000);
        re.startDate = re.startAt.toDate();
        re.allowDays = getAllowDays(task);
        re.nextRunDatetime = getNextRunDatetime(task, re.allowDays);
        return re;
    } catch (err) {
        log.error('scheduler:get-times', err);
    }
};