const log = require('electron-log');

const checkContentObject = (object) => {
    try {
        let checked = true;

        if ( !object ) {
            checked = false;
        } else if ( !object.script || object.script.length === 0 ) {
            checked = false;
        } else if ( !checkScriptArray(object.script) ) {
            checked = false;
        }

        return checked;
    } catch (e) {
        log.error('getStartBlocksTime() -> checkContentObject()', e);
    }
};

const checkScriptArray = (array) => {
    try {
        let checked = true;

        for ( let i = 0; i < array.length; i++ ) {
            if ( !checkScriptContent(array[i].script_content) ) {
                checked = false;

                break;
            }
        }

        return checked;
    } catch (e) {
        log.error('getStartBlocksTime() -> checkScriptArray()', e);
    }
};

const checkScriptContent = (array) => {
    try {
        let checked = true;

        for ( let i = 0; i < array.length; i++ ) {
            const isContentServerPath = array[i].content_server_path && array[i].content_server_path[0] > '';
            const isStartTime = array[i].start_time && array[i].start_time[0] >= 0;

            if ( !isContentServerPath || !isStartTime ) {
                checked = false;

                break;
            }
        }

        return checked;
    } catch (e) {
        log.error('getStartBlocksTime() -> checkScriptContent()', e);
    }
};

module.exports = checkContentObject;
