const _ = require('lodash');
const log = require('electron-log');
const moment = require('moment');

moment.locale('en');

module.exports = function (data, key) {
    try {
        const currentHours = parseInt(moment().format('HH'), 10);
        const currentDayName = moment().format('dddd').toLowerCase();
        let content = false;
        const toInt = (str) => parseInt(str, 10);
        const checkTime = (item) => item.all_time || (toInt(item.time_start) <= currentHours && toInt(item.time_end) > currentHours);
        const checkDay = (item) => item.all_day || item.day === currentDayName;

        if ( data && data[key] && data[key].length > 0 ) {
            for ( let i = 0; i < data[key].length; i++ ) {
                if ( checkTime(data[key][i]) && checkDay(data[key][i]) ) {
                    content = data[key][i];

                    break;
                }
            }
        }

        return content;
    } catch (err) {
        log.error('find-content-for-today', err);
    }
};
