const log = require('electron-log');

const popup = require('./popup');
const getParams = require('../get-params');

try {
    document.addEventListener('info-popup.afterShow', () => {
        updateOnlineStatus(navigator.onLine);
        updateNet();
    });
} catch (e) {
    log.error('Error: info-popup/common event listeners', e);
}

const updateOnlineStatus = (status) => {
    try {
        if ( popup.isHiddenPopup() ) {
            return false;
        }

        popup.elem.querySelector('.js-info-popup__online-status').innerHTML = status;
    } catch (e) {
        log.error('Error: info-popup/common updateOnlineStatus()', e);
    }
};

const updateNet = async () => {
    try {
        if ( popup.isHiddenPopup() ) {
            return false;
        }

        const { ipAddress, macAddress, serverPort } = await getParams('ipAddress', 'macAddress', 'serverPort');

        popup.elem.querySelector('.js-info-popup__ip').innerHTML = ipAddress;
        popup.elem.querySelector('.js-info-popup__mac-address').innerHTML = macAddress;
        popup.elem.querySelector('.js-info-popup__server-port').innerHTML = serverPort;
    } catch (e) {
        log.error('Error: info-popup/common updateOnlineStatus()', e);
    }
};

module.exports = {
    updateOnlineStatus,
};
