const ipcMain = require('electron').ipcMain || require('electron').remote.ipcMain;
const log = require('electron-log');

module.exports = (...args) => new Promise((resolve, reject) => {
    const result = {};

    try {
        const promises = [];

        args.forEach((argument) => {
            promises[promises.length] = new Promise((resolve) => {
                ipcMain.once('send-param', (answer) => {
                    result[argument] = answer;
                    resolve();
                });
                ipcMain.emit('get-param', argument);
            });
        });

        ipcMain.removeAllListeners('send-param');

        Promise.all(promises).finally(() => {
            resolve(result);
        });
    } catch (err) {
        log.error('mod:get-params', err);
        reject(result);
    }
});
