const log = require('electron-log');

const heshChecker = require('../hesh-checker');
const removeItem = require('./remove-item');

const downloadItemDone = (itemPath, itemHesh) => {
    try {
        let checked = false;

        if ( heshChecker.check(itemPath, itemHesh) ) {
            heshChecker.save(itemPath, itemHesh);

            log.info('mod:content-loader/then-item-done', 'item checked');

            checked = true;
        } else {
            heshChecker.remove(itemPath);

            removeItem(itemPath);

            log.warn('mod:content-loader/then-item-done', 'check item broken and removed');

            checked = false;
        }

        return checked;
    } catch (e) {
        log.error('mod:content-loader/then-item-done broken', e);
    }
};

module.exports = downloadItemDone;