const {app} = require('electron');
const log = require('electron-log');
const unzip = require('extract-zip');
const path = require('path');

const findContent = require('../jsondata/find-content-for-today');

module.exports = function (data) {
    try {
        const appUserData = app.getPath('userData');
        const buttonsDataDir = path.join(appUserData, 'buttonsData');
        const content = findContent(data, '_button');

        if ( typeof content !== 'object' ) {
            return false;
        } else if ( !content.script[0].script_content[0].content_server_path[0] ) {
            log.error('unzip buttons data: script.script_content[0].content_server_path not exist');
            return false;
        } else if ( !buttonsDataDir ) {
            log.error('unzip buttons data: buttons dir not exist');
            return false;
        }

        const archivePath = path.join(appUserData, content.script[0].script_content[0].content_server_path[0]);
        const extractEnd = function (err) {
            if ( err ) {
                log.error(err);
                return false;
            }
        };

        switch ( path.parse(archivePath).ext ) {
            case('.zip'):
                unzip(archivePath, {dir: buttonsDataDir}, extractEnd);
                log.warn('mod: extract-buttons: buttons unarchived!');
                break;
            // case('.rar'):
            //     let arch = new unrar(current.data._button.putTo[0]);
            //     arch.extract(buttonsDataDir, null, extractEnd);
            //     break;
            default:
                log.warn('extract archive not *zip');
        }
    } catch (err) {
        log.error(err);
    }
};