const electron = require('electron');
const { BrowserWindow } = electron;
const log = require('electron-log');
const isDev = require('electron-is-dev');

const createWindow = (newOptions = {}) => {
    try {
        const options = Object.assign({
            width: electron.screen.getPrimaryDisplay().size.width,
            height: (isDev ? 800 : electron.screen.getPrimaryDisplay().size.height),
            // x: 0,
            // y: 0,
            resizable: isDev,
            movable: isDev,
            frame: isDev,
            kiosk: !isDev,
            fullscreen: !isDev,
            alwaysOnTop: false,
            webPreferences: {
                defaultEncoding: 'utf8',
                nodeIntegration: true,
                enableRemoteModule: true
            }
        }, newOptions);
        let win = new BrowserWindow(options);

        win.on('closed', () => win = null);

        return win;
    } catch (e) {
        log.error('createWindow(win):\n', e);

        return null;
    }
};

module.exports = createWindow;
