const { app } = require('electron');
const log = require('electron-log');
const isDev = require('electron-is-dev');

const createWindow = require('./createWindow.js');

let winMain = null;

const init = () => {};

const createWin = () => {
    winMain = createWindow({ id: 'main' });
    winMain.loadFile('src/content.html');// path from app root

    return winMain;
};

const setAppListeners = () => {
    app.on('will-quit', () => log.info('will-quit'));

    app.on('before-quit', () => log.info('before-quit'));

    app.on('window-all-closed', () => {
        log.info('window-all-closed, quit');

        app.quit();
    });
};

const afterPageReady = () => {
    if (isDev) {
        winMain.webContents.openDevTools();
    } else {
        setTimeout(() => {
            winMain.setSize(
                screen.getPrimaryDisplay().size.width,
                screen.getPrimaryDisplay().size.height,
                false
            );
        }, 15 * 1000);
    }
};

module.exports = {
    createWin,
    setAppListeners,
    afterPageReady
};
