import winston = require('winston');

import statisticFormat from './formats/statistics-format';
import {
  debugTransport,
  errorTransport,
  infoTransport, messagesTransport,
  statisticsTransport,
} from './transports/transports';
import { format } from 'winston';
import * as dayjs from 'dayjs';

const { combine, timestamp } = winston.format;

const logger = winston.createLogger({
  levels: {
    error: 1,
    debug: 2,
  },
  format: timestamp({
    format: 'MMM-DD-YYYY HH:mm:ss:ms',
  }),

  transports: [errorTransport, debugTransport],
});

const infoLogger = winston.createLogger({
  levels: {
    info: 1,
  },
  format: timestamp({
    format: 'MMM-DD-YYYY HH:mm:ss:ms',
  }),

  transports: [infoTransport],
});

const loggerStatistic = winston.createLogger({
  levels: {
    statistics: 1,
  },
  format: combine(
    timestamp({
      format: 'MMM-DD-YYYY HH:mm:ss:ms',
    }),
    statisticFormat,
  ),
  transports: [statisticsTransport],
});

const loggerMessage = winston.createLogger({
  levels: {
    message: 1,
  },
  format: combine(
    timestamp({
      format: 'MMM-DD-YYYY HH:mm:ss:ms',
    }),
    format.printf((args) => {
      return `${args.message}|${dayjs(args.timestamp).format('HH:mm')}`;
    })
  ),
  transports: [messagesTransport],
});

export { logger, infoLogger, loggerStatistic, loggerMessage };
