import * as DailyRotateFile from 'winston-daily-rotate-file';
import winston = require('winston');

const { prettyPrint } = winston.format;
const logPath = 'logs/kasu-package';

const statisticsTransport = new DailyRotateFile({
  filename: `${logPath}/%DATE%/statistics-%DATE%.log`,
  datePattern: 'DD-MM-YYYY',
  level: 'statistics',
  json: true,
});

const infoTransport: DailyRotateFile = new DailyRotateFile({
  filename: `${logPath}/%DATE%/info-%DATE%.log`,
  datePattern: 'DD-MM-YYYY',
  level: 'info',
  format: prettyPrint(),
  json: true,
});

const errorTransport: DailyRotateFile = new DailyRotateFile({
  filename: `${logPath}/%DATE%/error-%DATE%.log`,
  datePattern: 'DD-MM-YYYY',
  format: prettyPrint(),
  json: true,
  level: 'error',
});

const debugTransport: DailyRotateFile = new DailyRotateFile({
  filename: `${logPath}/%DATE%/debug-%DATE%.log`,
  datePattern: 'DD-MM-YYYY',
  format: prettyPrint(),
  json: true,
  level: 'debug',
});

const messagesTransport: DailyRotateFile = new DailyRotateFile({
  filename:`${logPath}/message.log`,
  level: 'message',
  frequency: '24h',
  maxFiles: 1,
  eol: "\r\n"
});


// const combinedTransport: DailyRotateFile = new DailyRotateFile({
//   filename: `${logPath}/%DATE%/combined-%DATE%.log`,
//   datePattern: 'DD-MM-YYYY',
//   format: prettyPrint(),
//   json: true,
// });

export {
  statisticsTransport,
  infoTransport,
  errorTransport,
  debugTransport,
  messagesTransport,
  // combinedTransport,
};
