const KSOModule = require('../dist/index.js');

// Все кнопки
const buttonStartWs = document.getElementById('start-ws');
const buttonStartHttp = document.getElementById('start-http');
const buttonBlock = document.getElementById('block-btn');
const buttonUnBlock = document.getElementById('unblock-btn');
const buttonPostPaid = document.getElementById('postPaid-btn');
const buttonPrePaid = document.getElementById('prePaid-btn');
const buttonQrCode = document.getElementById('qrCode-btn');
const buttonAccept = document.getElementById('start-btn-accept');
const buttonPay = document.getElementById('start-btn-pay');
const sendButton = document.getElementById('send-btn');

// Селекты и инпуты
const firstSelect = document.getElementById('payChouseSelect');
const secondSelect = document.getElementById('secondSelect');
const thirdSelect = document.getElementById('thirdSelect');
const litersOrPrice = document.getElementById('countChouseSelect'); //выбор в литрах или по цене
const numberUnitsInput = document.getElementById('number-units');
const qrCodeInput = document.getElementById('qr-code');
const numberPhoneInput = document.getElementById('number-phone');
const numberBeeperInput = document.getElementById('number-beeper');
const orderToGoSelect = document.getElementById('orderToGoSelect');
const paymentMethodSelect = document.getElementById('paymentMethodSelect');
const loyalityChouseSelect = document.getElementById('loyalityChouseSelect');
const fuelCardChouseSelect = document.getElementById('fuelCardChouseSelect');

// Контейнеры
const cardContainer = document.querySelector('.box__cardContainer');
const cartContainer = document.querySelector('.box__cartContainer');
const confirmationBlock = document.querySelector('#confirmationBlock');
const visualBlock = document.querySelector('.box__visual');
const visualParagraph = document.querySelector('.visual-paragraph');

const btnsContainer = document.getElementById('button__box__2');

// Переменная для отправки разблокировки/блокировки ТРК
let fpLockValue;

// Переменная со списком сторон ТРК
let configNozzles;

// Переменная с конфигурациями КСО
let stationConfigValue;

// Переменная отвечающая за сумму или кол-во литров в предоплатном наливе
let quantityData;

// Флаг для активации кнопки налива по пост-оплате
let flagAddFuelPost = false;

// Флаг для активации кнопки налива по предоплате
let flagAddFuelPre = false;

// Переменная с массивом картинок
let imageData;

// Переменная отвечающая за формирование корзины
let basketData;

// Переменная отвечающая за различные опции по КСО
let optionsUpdateData;

// Переменная хранящая массив с данными о состоянии ТРК
let fpStatusData;

// Переменная хранящая массив данных о меню
let menuCafeServiceData;

// Переменная для хранения номера телефона
let numberPhoneValue = null;

// Переменная для хранения номера бипера
let numberBeeperValue = null;

// Флаг для вопроса, заказ с собой?
let flagOrderToGo = true;

// Флаг для вопроса, применять карту лояльности?
let flagLoyalityToGo = true;

// Флаг для вопроса, оплата топливной картой?
let flagFuelToGo = true;

// Способ оплаты - банковской/топливной картой или СПБ
let paymentMethodValue = paymentMethodSelect.options[0].value;

// Переменная с номером заказа
let numberOrder;

// const mockButtons = [
//   {
//     controlType: 0,
//     name: 'btnYes',
//     default: false,
//     text: 'Да',
//     validate: false,
//     value: null,
//   },
//   {
//     controlType: 0,
//     name: 'btnNo',
//     default: false,
//     text: 'Нет',
//     validate: false,
//     value: null,
//   },
// ];

// console.log(123);

// for (let btn of mockButtons) {
//   console.log(btn);
//   const button = document.createElement('button');
//   button.id = btn.id;
//   btnsContainer.appendChild(button);
//   // btnsContainer.innerHTML += `<button id=${btn.name}>${btn.name}</button>`;
//   // const btnHtml = document.getElementById(btn.name);
//   // btnHtml.addEventListener('click', () => {
//   //   KSOModule.pressedButton(btn.name);
//   // });
// }

// btnsContainer.addEventListener('click', (event) => {
//   const isButton = event.target.nodeName === 'BUTTON';
//   if (!isButton) {
//     return;
//   }

//   console.log(event.target.id);

//   KSOModule.pressedButton(event.target.id);
// });

// Подключаем оповещение на дополнительную информацию
KSOModule.on('info', (info) => console.log(info));

// Подключаем оповещение на ошибки
KSOModule.on('error', console.error);

// Подписываемся на получение меню и отрисовку карточек меню
KSOModule.on('menuData', (info) => {
  //отрисовка карточек
  cardContainer.innerHTML = '';
  info.dataModule.productGroups.forEach((productObj) => {
    productObj.products.forEach((products) => {
      //! externalId параметр необходимый для добавления товара в корзину.
      createCart(
        productObj.name,
        products.printName,
        products.shortName,
        products.id,
        products.externalId,
        products.price.value,
      );
    });
  });
  console.log('Меню получено');
});

// Подписываемся на получения подтверждения на оплату чека
KSOModule.on('paymentSuccessful', () => {
  console.log('Оплата чека прошла успешно !');
});

// Подписываемся на получения подтверждения о сформирования заказа и получения номера заказа
KSOModule.on('acceptOrderCheck', (order) => {
  numberOrder = order;
  console.log(`Сформирован заказ по номеру ${numberOrder}`);
});

// Подписываемся на получения информационных сообщений для взаимодействия с клиентом
KSOModule.on('arrivalMessage', (message) => {
  // Вывод сообщения message
});

// Подписываемся на получения массива с кнопками (списывать или нет баллы), плюс title(информационное сообщение о доступных баллах)
KSOModule.on('requestCallback', (buttonsArr) => {
  // Манипуляция с кнопками из buttonsArr
  // for (let btn of buttonsArr) {
  //   btnsContainer.innerHTML += <button id={btn.name}>btn.name</button>;
  //   // const btnHtml = document.getElementById(btn.name);
  //   // btnHtml.addEventListener('click', () => {
  //   //   KSOModule.pressedButton(btn.name);
  //   // });
  // }
  // btnsContainer.addEventListener('click', (event) => {
  //   const isButton = event.target.nodeName === 'BUTTON';
  //   if (!isButton) {
  //     return;
  //   }
  //   console.log(event.target.id);
  //   KSOModule.pressedButton(event.target.id);
  // });
});

// Подписываемся на получения сообщения ввести проверочный код + номер телефона (куда придёт)
KSOModule.on('arrivalOtpCode', (message) => {
  // Вывод сообщения message
});

// Подписываемся на получения сообщения о том, что введён не правильный проверочный код (на списание баллов)
KSOModule.on('informationMessageFromKSO', (message) => {
  // Вывод сообщения message
});

// Подписываемся на получения сообщения с остатком времени в секундах, после которого можно запросить код повторно
KSOModule.on('arrivalOtpTimerValue', (message) => {
  // Вывод сообщения message с кол-во секунд
});

// Подписываемся на получения id клиента
KSOModule.on('callbackClientData', (message) => {
  // Вывод сообщения message с  id клиента
});

//Подписки на событие получения картинок с товарами
KSOModule.on('imagesDataAll', (imagesDataAllData) => {
  imageData = imagesDataAllData;
});

//Подписки на событие получения подтверждения доступности/недоступности сервиса КАСУ
KSOModule.on('serviceAvailableCheck', (serviceFlag) => {
  return serviceFlag ? console.log('Сервис доступен') : console.log('Сервис недоступен');
});

//Подписки на событие получения конфигурации КСО
KSOModule.on('stationConfig', (stationConfigData) => {
  stationConfigValue = stationConfigData;
});

//Подписки на событие получения конфигурации ТРК (все колонки и баки с топливом)
KSOModule.on('fpConfig', (fpConfigData) => {
  configNozzles = fpConfigData.fps;
  fillingSecondSelect();
});

//Подписки на событие получения настроек АЗС (различные таймауты, кол-во биперов и тд)
KSOModule.on('optionsUpdate', (e) => (optionsUpdateData = e));

//Подписки на событие получения состояний ТРК (реализованно собирания их в общий массив)
KSOModule.on('fpStatus', () => {
  fpStatusData = KSOModule.getDataModule().arrStateTRK;
  console.log('fpStatus', fpStatusData);
  createVisualBox();
});

//Подписки на событие получения данных о корзине и на основе его полей создание карточек в корзине
KSOModule.on('basketUpdate', (basketUpdateData) => {
  basketData = basketUpdateData;
  console.log(basketData);
  if (
    basketData.cheque !== null &&
    basketData.cheque.lines &&
    basketData.cheque.lines.length !== 0
  ) {
    //отрисовка карточек
    cartContainer.innerHTML = '';
    confirmationBlock.style.display = 'flex';
    basketData.cheque.lines.forEach((product) => {
      //! externalId параметр необходимый для добавления товара в корзину.
      createCartBasket(
        product.id,
        product.product.price,
        product.product.longName,
        product.product.shortName,
        product.quantityPlan,
      );
    });
    const button = document.createElement('button'); //Создаем кнопку для отмены заказа
    button.classList.add('box__addToCart'); //Добавляем класс
    button.textContent = 'Отмена'; //Добавляем текст кнопке
    button.onclick = function () {
      KSOModule.cancelOrder();
    }; //Добавляем клик кнопке
    cartContainer.appendChild(button);
  } else {
    cartContainer.innerHTML = '';
    confirmationBlock.style.display = 'none';
    const paragraph = document.createElement('p');
    paragraph.innerHTML = '<strong>Корзина пуста</strong>';
    cartContainer.appendChild(paragraph);
  }
});

// Функция создание карточек с товарами
function createCart(
  category = 'category',
  title = 'title',
  description = 'description',
  id = 1,
  productId,
  price,
) {
  const cardDiv = document.createElement('div'); //Создаем контейнер для карточек
  cardDiv.classList.add('box__card'); //Добавляем класс

  const categoryText = document.createElement('p');
  categoryText.innerHTML = '<strong>категория:</strong> ' + `${category}`; //Добавляем заголовок
  cardDiv.classList.add('box__cardFonts'); //Добавляем класс

  const titleParagraph = document.createElement('p'); //Создаем заголовок карточки
  titleParagraph.innerHTML = '<strong>заголовок:</strong> ' + `${title}`; //Добавляем заголовок

  const idCardText = document.createElement('p'); //Создаем id карточки
  idCardText.textContent = `id: ${(id += 1)}`; //Добавляем id

  const descriptionParagraph = document.createElement('p'); //Создаем описание карточки
  descriptionParagraph.innerHTML = '<strong>описание:</strong> ' + `${description}`; //Добавляем описание

  const button = document.createElement('button'); //Создаем кнопку для добавления карточки в корзину
  button.classList.add('box__addToCart'); //Добавляем класс карточки
  button.textContent = 'добавить'; //Добавляем текст кнопке
  button.onclick = function () {
    KSOModule.addProductToCart(productId, price);
  }; //Добавляем клик кнопке

  //Добавляем созданные элементы в div(контейнер)
  cardDiv.appendChild(categoryText);
  cardDiv.appendChild(titleParagraph);
  cardDiv.appendChild(idCardText);
  cardDiv.appendChild(descriptionParagraph);
  cardDiv.appendChild(button);
  cardContainer.appendChild(cardDiv);
}

/** Функция для визуализации свободных и заблокированных сторон ТРК */
function createVisualBox() {
  if (!fpStatusData) {
    return;
  }
  visualBlock.innerHTML = '';
  fpStatusData.map((el) => {
    const cardDiv = document.createElement('div');
    const blockDiv = document.createElement('div');
    cardDiv.classList.add('card__box');
    if (!!el.logicalNozzleId) {
      const valueFuel = configNozzles
        .find((e) => e.id == el.fpId)
        .nozzles.find((elem) => elem.id == el.logicalNozzleId).productName;
      blockDiv.innerHTML = `<strong>${valueFuel}</strong>`;
      blockDiv.classList.add('card__visual_block');
    } else {
      blockDiv.innerHTML = '<strong>Свободно</strong>';
      blockDiv.classList.add('card__visual');
    }
    const blockText = document.createElement('p');
    blockText.innerHTML = `${el.fpId}`;
    blockText.classList.add('card__textVisual');
    cardDiv.appendChild(blockDiv);
    cardDiv.appendChild(blockText);
    visualBlock.appendChild(cardDiv);
  });
}

// Функция создание карточек с товарами
function createCartBasket(id, price, longName, shortName, quantityFact) {
  const cardDiv = document.createElement('div'); //Создаем контейнер для карточек
  cardDiv.classList.add('box__card'); //Добавляем класс

  const categoryText = document.createElement('p');
  categoryText.innerHTML = '<strong>Название позиции:</strong> ' + `${longName}`; //Добавляем заголовок
  cardDiv.classList.add('box__cardFonts'); //Добавляем класс

  const idCardText = document.createElement('p'); //Создаем id карточки
  idCardText.textContent = `id: ${id}`; //Добавляем id

  const priceCart = document.createElement('p'); //Создаем заголовок карточки
  priceCart.innerHTML = '<strong>Цена позиции:</strong> ' + `${price * quantityFact}`; //Добавляем заголовок

  const descriptionParagraph = document.createElement('p'); //Создаем описание карточки
  descriptionParagraph.innerHTML =
    '<strong>Короткое название:</strong> ' + `${shortName}`; //Добавляем описание

  const button = document.createElement('button'); //Создаем кнопку
  button.classList.add('box__addToCart'); //Добавляем класс
  button.textContent = 'Удалить'; //Добавляем текст кнопке
  button.onclick = function () {
    KSOModule.deleteProduct(id);
  }; //Добавляем клик кнопке

  //Добавляем созданные элементы в div(контейнер)
  cardDiv.appendChild(categoryText);
  cardDiv.appendChild(idCardText);
  cardDiv.appendChild(priceCart);
  cardDiv.appendChild(descriptionParagraph);
  cardDiv.appendChild(button);
  cartContainer.appendChild(cardDiv);
}

// Кнопка для подключения к модулю (инициализация)
buttonStartWs.addEventListener('click', () => {
  KSOModule.connect(
    // 'ws://192.168.1.200:8088',
    // 'ws://94.26.226.9:8866', // EMULATOR
    'ws://localhost:3000', // LOCAL
    'NeuroCity', // CafeKiosk && NeuroCity
    'kiosk 1', // KIOSK && КСО 1
  );
  visualParagraph.style.display = 'block';
});

// Кнопка для подключения к модулю (инициализация)
buttonStartHttp.addEventListener('click', () => {
  // KSOModule.fetchMenuKASU('http://192.168.1.200:8085/pa-cafe-service/kiosk/getConfig');
  // KSOModule.fetchMenuKASU('http://94.26.226.9:8866'); // EMULATOR
  KSOModule.fetchMenuKASU('http://localhost:3000'); // LOCAL
});

// Функция для очистки селекта от опций
function clearSelect(selectElement) {
  selectElement.innerHTML = '';
}

// Функция для определения способа оплаты топлива + реализация недоступности/доступности элементов, в зависимости от выбора
firstSelect.addEventListener('change', () => {
  switch (firstSelect.value) {
    case 'pre':
      qrCodeInput.disabled = true;
      numberUnitsInput.disabled = false;
      qrCodeInput.title = 'Заблокировано, выберите актуальный способ оплаты';
      litersOrPrice.disabled = false;
      litersOrPrice.removeAttribute('title');
      clearSelect(secondSelect);
      clearSelect(thirdSelect);
      fillingSecondSelect();
      buttonUnBlock.disabled = false;
      buttonBlock.disabled = false;
      buttonQrCode.disabled = true;
      buttonQrCode.title = 'Заблокировано, выберите актуальный способ оплаты';
      break;
    case 'post':
      qrCodeInput.disabled = true;
      numberUnitsInput.disabled = true;
      qrCodeInput.title = 'Заблокировано, выберите актуальный способ оплаты';
      numberUnitsInput.title = 'Заблокировано, выберите актуальный способ оплаты';
      litersOrPrice.disabled = true;
      litersOrPrice.title = 'Заблокировано, выберите актуальный способ оплаты';
      clearSelect(secondSelect);
      clearSelect(thirdSelect);
      fillingSecondSelect();
      buttonUnBlock.disabled = true;
      buttonBlock.disabled = true;
      buttonQrCode.title = 'Заблокировано, выберите актуальный способ оплаты';
      buttonQrCode.disabled = true;
      buttonPostPaid.disabled = false;
      buttonPostPaid.removeAttribute('title');
      break;
    case 'qr':
      qrCodeInput.disabled = false;
      numberUnitsInput.disabled = true;
      numberUnitsInput.title = 'Заблокировано, выберите актуальный способ оплаты';
      qrCodeInput.removeAttribute('title');
      litersOrPrice.disabled = true;
      litersOrPrice.title = 'Заблокировано, выберите актуальный способ оплаты';
      clearSelect(thirdSelect);
      clearSelect(secondSelect);
      buttonUnBlock.disabled = true;
      buttonBlock.disabled = true;
      buttonQrCode.disabled = false;
      break;
  }
});

// Обработчик инпутов
qrCodeInput.addEventListener('change', () => {
  fpLockValue = qrCodeInput.value;
});
numberUnitsInput.addEventListener('change', () => {
  quantityData = numberUnitsInput.value;
});
numberPhoneInput.addEventListener('change', () => {
  numberPhoneValue = numberPhoneInput.value;
});
numberBeeperInput.addEventListener('change', () => {
  numberBeeperValue = numberBeeperInput.value;
});

// Обработчик для формирования переменной flagOrderToGo (Флаг для вопроса, заказ с собой?)
orderToGoSelect.addEventListener('change', () => {
  console.log(orderToGoSelect.value);
  flagOrderToGo = orderToGoSelect.value;
});

// Обработчик для формирования переменной paymentMethodValue (Способ оплаты - банковской/топливной картой или СПБ)
paymentMethodSelect.addEventListener('change', () => {
  console.log(paymentMethodSelect.value);
  paymentMethodValue = paymentMethodSelect.value;
});

// Обработчик для формирования переменной flagLoyalityToGo (Флаг для вопроса, применять карту лояльности?)
loyalityChouseSelect.addEventListener('change', () => {
  console.log(loyalityChouseSelect.value);
  flagLoyalityToGo = loyalityChouseSelect.value;
});

// Обработчик для формирования переменной flagFuelToGo (Флаг для вопроса, оплата топливной картой?)
fuelCardChouseSelect.addEventListener('change', () => {
  console.log(fuelCardChouseSelect.value);
  flagFuelToGo = fuelCardChouseSelect.value;
});

// Обработчик для третьего селекта и формирование объекта для предоплатного налива топлива
thirdSelect.addEventListener('change', () => {
  if (fpLockValue && stationConfigValue) {
    fpLockValue = typeof obj === 'object' ? fpLockValue.fpId : fpLockValue;
    fpLockValue = {
      fpId: fpLockValue,
      lockId: stationConfigValue.pos.id,
      nozzleId: thirdSelect.value,
    };
  }
});

// Функция для заполнения options ~ второго селекта
function fillingSecondSelect() {
  if (configNozzles) {
    configNozzles.forEach(function (item) {
      const optionElement = document.createElement('option');
      optionElement.text = item.id;
      optionElement.value = item.id;
      secondSelect.appendChild(optionElement);
    });
    secondSelect.value = configNozzles[0].id;
    if (firstSelect.value === 'post') {
      fpLockValue = secondSelect.value;
    }
    if (firstSelect.value === 'pre') {
      fillingSThirdSelect(configNozzles[0].id);
    }
  }
}

// Обработчик второго селекта, для заполнения третьего
secondSelect.addEventListener('change', () => {
  thirdSelect.innerHTML = '';
  fillingSThirdSelect(secondSelect.value);
  fpLockValue = secondSelect.value;
});

// Функция для заполнения options ~ третьего селекта
function fillingSThirdSelect(idValue) {
  if (configNozzles && idValue) {
    const filteredConfigNozzles = configNozzles.find((el) => el.id == idValue);
    filteredConfigNozzles.nozzles.forEach((item) => {
      const optionElement = document.createElement('option');
      optionElement.text = item.productName;
      optionElement.value = item.id;
      thirdSelect.appendChild(optionElement);
    });
    thirdSelect.value = filteredConfigNozzles.nozzles[0].id;
    fpLockValue = {
      fpId: filteredConfigNozzles.nozzles[0].id,
      lockId: stationConfigValue.pos.id,
      nozzleId: thirdSelect.value,
    };
  }
}

// Блок кода отвечающий за доступность/недоступность кнопки постоплаты
if (flagAddFuelPost === false) {
  buttonPostPaid.disabled = true;
  buttonPostPaid.title =
    'Оплата постоплате  заблокированна, пока не произведена блокировка ТРК';
} else {
  buttonPostPaid.disabled = false;
  buttonPostPaid.removeAttribute('title');
}

// Блок кода отвечающий за доступность/недоступность кнопки предоплаты
if (flagAddFuelPre === false) {
  buttonPrePaid.disabled = true;
  buttonPrePaid.title =
    'Оплата по предоплате заблокирована, пока не произведена блокировка ТРК';
} else {
  buttonPrePaid.disabled = false;
  buttonPrePaid.removeAttribute('title');
}

// Кнопка для разблокировки соответствующего ТРК
buttonUnBlock.addEventListener('click', () => {
  if (!fpLockValue || !stationConfigValue) {
    return;
  }
  KSOModule.fpUnlock(fpLockValue.fpId, fpLockValue.lockId, fpLockValue.nozzleId);
  flagAddFuelPre = true;
});

// Кнопка для блокировки соответствующего ТРК
buttonBlock.addEventListener('click', () => {
  if (!fpLockValue || !stationConfigValue) {
    return;
  }
  console.log('fpLockValue', fpLockValue);
  KSOModule.fpLock(fpLockValue.fpId, fpLockValue.lockId, fpLockValue.nozzleId);
  buttonPrePaid.disabled = false;
  buttonPrePaid.removeAttribute('title');
});

// Кнопка для добавления предоплатного способа оплаты
buttonPrePaid.addEventListener('click', () => {
  if (!fpLockValue || !quantityData) {
    return;
  }
  const flag = litersOrPrice.value === 'liter' ? false : true;
  KSOModule.addFuelLine(fpLockValue.nozzleId, flag, quantityData);
  buttonPrePaid.disabled = true;
  buttonPrePaid.title =
    'Оплата по предоплате заблокирована, пока не произведена блокировка ТРК';
});

// Кнопка для добавления постоплатного способа оплаты
buttonPostPaid.addEventListener('click', () => {
  KSOModule.addPostPayFuel(fpLockValue);
  buttonPostPaid.disabled = true;
  buttonPostPaid.title =
    'Оплата постоплате  заблокированна, пока не произведена блокировка ТРК';
  flagAddFuelPost = false;
});

// Кнопка для добавления товара по qr-коду
buttonQrCode.addEventListener('click', () => {
  KSOModule.addProductScan(fpLockValue);
});

// Кнопка для подтверждения заказа
buttonAccept.addEventListener('click', () => {
  console.log(
    Boolean(numberBeeperValue) ? numberBeeperValue : '',
    Boolean(numberPhoneValue) ? numberPhoneValue : '',
    Boolean(flagOrderToGo) ? flagOrderToGo : '',
  );

  KSOModule.acceptOrder(
    Boolean(numberPhoneValue) ? numberPhoneValue : '',
    Boolean(numberBeeperValue) ? numberBeeperValue : '',
    Boolean(flagOrderToGo) ? flagOrderToGo : '',
  );
});

// Кнопка начала оплаты с соответствующими параметрами
buttonPay.addEventListener('click', () => {
  console.log(paymentMethodValue, flagLoyalityToGo, flagFuelToGo);
  KSOModule.startPay(paymentMethodValue, flagLoyalityToGo, flagFuelToGo);
});

sendButton.addEventListener('click', () => {
  KSOModule.pressedButton('btnYes');
});
