import type { DataModule } from './types';
import ButtonsOtp from './shared/const';
/** Функция для получения объект со всеми данными */
declare const getDataModule: () => DataModule;
/** Подключение оповещений(эмиттерев) */
declare const on: (event: string | symbol, action: (data: any) => void) => void;
/** Функция для установления websocket соединения и получения всех первичных и основных данных , кроме меню*/
declare function connect(urlWs: string, ClientProgramValue: string, ClientNameValue: string): void;
/** Функция для получения меню КАСУ с помощью HTTP запроса */
declare function fetchMenuKASU(urlHttp: string): false | undefined;
/** функция для добавления продукта из меню КСО в корзину */
declare function addProductToCart(productId: number, price: number): void;
/** Функция добавления товара с помощью скана */
declare function addProductScan(code: string): void;
/** Функция для удаления товара(Идентификатор строки заказа) */
declare function deleteProduct(chequeLineId: number): void;
/** Функция для предоплатного налива */
declare function addFuelLine(nozzleId: number, isFuellingInMoney: boolean, quantity: number): null | undefined;
/** Функция для постоплатного налива */
declare function addPostPayFuel(fpId: number): void;
/** Функция для отмены всего заказа (очищает корзину) */
declare function cancelOrder(): void;
/** Функция блокировки ТРК */
declare function fpLock(fpId: number, lockId: number, nozzleId: number): void;
/** Функция разблокировки ТРК */
declare function fpUnlock(fpId: number, lockId: number, nozzleId: number): void;
/** Функция для подтверждения заказа */
declare function acceptOrder(clientPhoneNumber: string, beeperNumber: string, takeAway: boolean): void;
/** Функция для отправки на сервер параметров оплаты заказа
 * @param {number} sellingTypeId - sellingTypeId.
 * @param {boolean} applyDiscount - true если необходимо применить карту лояльности.
 * @param {boolean} isLicardCard - true если оплата топливной картой.
 * @param {string} loyaltyCardNumber - Номер карты лояльности, запрошенной ранее через qr-код.
 * @param {0 | 1 | 2} loyaltyRequestType - Способ считывания qr-кода: 0 – неизвестно, 1 - сканер, 2 – терминал.
 * */
declare function startPay(sellingTypeId: number, applyDiscount: boolean, isLicardCard: boolean, loyaltyCardNumber: string, loyaltyRequestType: 0 | 1 | 2): void;
/** Функция для отправки на сервер сообщение о применении карты лояльности с QR кодом или clientId*/
declare function processQrLoyalty({ qrCode, idClient }: {
    qrCode?: string;
    idClient?: string;
}): void;
/** Функция для отправки на сервер нажатой кнопки(не/подтверждающий списание баллов) */
declare function pressedButton(pressButton: string): void;
/** Функция для отправки на сервер сообщения с введённым кодом
 *  @param {Object} data - Объект
 *  @param {ButtonsOtp} data.pressedButtons - название нажатой кнопки.
 *  @param {number} data.otpCode - OTP код.
 */
declare function loyaltyOtpCode(data?: {
    pressedButtons?: ButtonsOtp;
    otpCode?: number;
}): void;
/** Функция для запроса данных клиента (отправляем qr-лояльности) */
declare function getClientData(qrCode: string): void;
/** Функция для запроса полученных с КАСУ кнопок (из полученных кнопок отправляем name при помощи функции pressedButton) */
declare function getLoyaltyButtons(): DataModule['answerButtons'];
/** Функция для запроса полученных с КАСУ данных о пользователе */
declare function getClient(): DataModule['clientData'];
/** Функция для отмены всего заказа (очищает корзину) */
declare function cancelOrderWithRemoveCheckLines(): void;
/** Функция для отмены ожидания сканирования qr */
declare function resetTransaction(): void;
declare function getProductInfo(externalId: number): void;
/** Функция для удаления топлива из корзины, и восстановления остальных товаров в корзине */
declare function cancelOrderAndRecoverBasket(): void;
declare function setPingPongEnabled(enabled: boolean): void;
export { connect, addProductToCart, addProductScan, deleteProduct, addFuelLine, addPostPayFuel, cancelOrder, fpLock, fpUnlock, acceptOrder, startPay, processQrLoyalty, pressedButton, loyaltyOtpCode, on, getDataModule, fetchMenuKASU, getClientData, getLoyaltyButtons, getClient, cancelOrderAndRecoverBasket, cancelOrderWithRemoveCheckLines, resetTransaction, setPingPongEnabled, getProductInfo, };
