(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "winston", "winston-daily-rotate-file", "triple-beam"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.loggerStatistic = exports.logger = void 0;
    const winston = require("winston");
    const DailyRotateFile = require("winston-daily-rotate-file");
    const triple_beam_1 = require("triple-beam");
    const { combine, timestamp, prettyPrint } = winston.format;
    const logPath = 'logs/kasu-package';
    const statisticFormat = winston.format((info) => {
        const obj = JSON.parse(info.message);
        const beginDate = new Date(obj.data.data.cheque.beginDate);
        let fuelPrice = 0;
        let cafePrice = 0;
        obj.data.data.cheque.lines.forEach((item) => {
            var _a;
            if (item.nozzle === null)
                cafePrice += item.payments[0].amountPayment;
            if ((_a = item.nozzle) === null || _a === void 0 ? void 0 : _a.id) {
                fuelPrice += item.payments[0].amountPayment;
            }
        });
        info[triple_beam_1.MESSAGE] = `${beginDate.getHours()}:${beginDate.getMinutes()}:${beginDate.getSeconds()}\t${(+new Date(obj.data.data.cheque.printDate) - +beginDate) / 1000}\t${cafePrice}\t${fuelPrice}\t${obj.data.data.cheque.amountPayment}`;
        return info;
    })();
    const statisticsTransport = new DailyRotateFile({
        filename: `${logPath}/%DATE%/statistics-%DATE%.log`,
        datePattern: 'DD-MM-YYYY',
        level: 'statistics',
    });
    const infoTransport = new DailyRotateFile({
        filename: `${logPath}/%DATE%/info-%DATE%.log`,
        level: 'info',
        datePattern: 'DD-MM-YYYY',
        format: prettyPrint(),
    });
    const errorTransport = new DailyRotateFile({
        filename: `${logPath}/%DATE%/error-%DATE%.log`,
        level: 'error',
        datePattern: 'DD-MM-YYYY',
        format: prettyPrint(),
    });
    const debugTransport = new DailyRotateFile({
        filename: `${logPath}/%DATE%/debug-%DATE%.log`,
        level: 'debug',
        datePattern: 'DD-MM-YYYY',
        format: prettyPrint(),
    });
    const combinedTransport = new DailyRotateFile({
        filename: `${logPath}/%DATE%/combined-%DATE%.log`,
        datePattern: 'DD-MM-YYYY',
        format: prettyPrint(),
    });
    const logger = winston.createLogger({
        levels: {
            error: 0,
            warn: 1,
            info: 2,
            http: 3,
            verbose: 4,
            debug: 5,
            silly: 6,
            statistics: 7,
        },
        format: combine(timestamp({
            format: 'MMM-DD-YYYY HH:mm:ss',
        })),
        transports: [errorTransport, infoTransport, debugTransport, combinedTransport],
    });
    exports.logger = logger;
    const loggerStatistic = winston.createLogger({
        levels: {
            statistics: 7,
        },
        format: combine(timestamp({
            format: 'MMM-DD-YYYY HH:mm:ss',
        }), statisticFormat),
        transports: [statisticsTransport],
    });
    exports.loggerStatistic = loggerStatistic;
});
