(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "winston-daily-rotate-file", "fs"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    const DailyRotateFile = require("winston-daily-rotate-file");
    const fs = require("fs");
    const moment = require('moment');
    module.exports = class CustomTransport extends DailyRotateFile {
        constructor(options) {
            super(options);
            this.filename = (options === null || options === void 0 ? void 0 : options.filename) || '';
            if (this.filename.includes('%DATE%'))
                this.filename = this.filename.replace('%DATE%', moment(moment.now()).format('DD-MM-YYYY'));
            this.setup();
        }
        initialize() {
            try {
                fs.writeFileSync(this.filename, '[]', 'utf8');
            }
            catch (error) {
                console.log(error);
            }
        }
        setup() {
            // This checks if the file exists
            if (fs.existsSync(this.filename)) {
                // The content of the file is checked to know if it is necessary to adapt the array
                try {
                    const data = fs.readFileSync(this.filename, 'utf8');
                    // If the content of the file is not an array, it is set
                    const content = JSON.parse(data);
                    if (!Array.isArray(content)) {
                        this.initialize();
                    }
                }
                catch (error) {
                    this.initialize();
                    console.log(error);
                }
            }
            // Otherwise create the file with the desired format
            else {
                this.initialize();
            }
        }
        readLog() {
            let data = null;
            try {
                data = fs.readFileSync(this.filename, 'utf8');
            }
            catch (error) {
                console.log(error);
            }
            return data;
        }
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        writeLog(info) {
            const data = this.readLog();
            let arr = [];
            if (data) {
                arr = JSON.parse(data);
            }
            //add data
            arr.push(info);
            //convert it back to json
            const json = JSON.stringify(arr);
            try {
                // Writing the array again
                fs.writeFileSync(this.filename, json, 'utf8');
            }
            catch (error) {
                console.log(error);
            }
        }
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        log(info, callback) {
            setImmediate(() => {
                this.emit('logged', info);
            });
            // Perform the writing
            this.writeLog(info);
            callback();
        }
    };
});
