(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "fs", "winston-transport"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    const fs = require("fs");
    const TransportStream = require("winston-transport");
    class CustomTransport extends TransportStream {
        constructor(options) {
            super(options);
            this.filename = options.filename;
            this.level = options === null || options === void 0 ? void 0 : options.level;
            this.setup();
        }
        initialize() {
            try {
                fs.writeFileSync(this.filename, '[]', 'utf8');
            }
            catch (error) {
                console.log(error);
            }
        }
        setup() {
            // This checks if the file exists
            if (fs.existsSync(this.filename)) {
                // The content of the file is checked to know if it is necessary to adapt the array
                try {
                    const data = fs.readFileSync(this.filename, 'utf8');
                    // console.log(data);
                    // If the content of the file is not an array, it is set
                    const content = JSON.parse(data);
                    if (!Array.isArray(content)) {
                        this.initialize();
                    }
                }
                catch (error) {
                    this.initialize();
                    console.log(error);
                }
            }
            // Otherwise create the file with the desired format
            else {
                this.initialize();
            }
        }
        readLog() {
            let data = null;
            try {
                data = fs.readFileSync(this.filename, 'utf8');
            }
            catch (error) {
                console.log(error);
            }
            return data;
        }
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        writeLog(info) {
            console.log(123);
            const data = this.readLog();
            console.log(456);
            let arr = [];
            if (data) {
                arr = JSON.parse(data);
            }
            //add data
            arr.push(info);
            //convert it back to json
            const json = JSON.stringify(arr);
            console.log(typeof json);
            try {
                // Writing the array again
                console.log(json);
                fs.writeFileSync(this.filename, json, 'utf8');
            }
            catch (error) {
                console.log(error);
            }
        }
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        log(info, callback) {
            setImmediate(() => {
                this.emit('logged', info);
            });
            // Perform the writing
            this.writeLog(info);
            callback();
        }
    }
    exports.default = CustomTransport;
});
