interface BasketUpdate {
    msgType: string;
    data: Data;
}
interface Data {
    basketState: number;
    cheque: Cheque;
    clientCard: any;
    isAcceptEnabled: boolean;
    isCancelEnabled: boolean;
    isCopyEnabled: boolean;
    isDeferEnabled: boolean;
    isDisallowRollbackSellingType: boolean;
    isQuantityEnabled: boolean;
    isRepaymentEnabled: boolean;
    rollbackTransaction: boolean;
}
interface Cheque {
    id: number;
    additionalInfo: any;
    amountChange: number;
    amountPayment: number;
    amountReceived: number;
    beginDate: string;
    isDeferred: boolean;
    lines: Line[];
    loyaltyCardNum: any;
    number: any;
    printDate: string;
    qrCode: any;
    sellingTypeForRunAway: any;
}
export interface Line {
    id: number;
    inputType: number;
    isMarked: any;
    nozzle: any;
    payments: Payment[];
    price: number;
    product: Product;
    quantityFact: number;
    quantityPlan: number;
}
interface Payment {
    id: number;
    amountPayment: number;
    discounts: any[];
    sellingType: SellingType;
}
interface SellingType {
    id: number;
    isEnabled: boolean;
    isFullTankAllow: boolean;
    isGiftFleetCard: boolean;
    isLicardCard: boolean;
    name: string;
    tag: string;
}
interface Product {
    id: number;
    barCode: string;
    byCode: boolean;
    code: string;
    isLeaf: boolean;
    longName: string;
    name: string;
    parent: any;
    picture: any;
    pictureType: any;
    price: number;
    productType: ProductType;
    quantity: number;
    shortName: string;
    unitOfMeasure: UnitOfMeasure;
}
interface ProductType {
    id: number;
    commonProductType: number;
    tag: string;
}
interface UnitOfMeasure {
    id: number;
    shortName: string;
}
export type { BasketUpdate };
