(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "winston-daily-rotate-file", "winston"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.messagesTransport = exports.debugTransport = exports.errorTransport = exports.infoTransport = exports.statisticsTransport = void 0;
    const DailyRotateFile = require("winston-daily-rotate-file");
    const winston = require("winston");
    const { prettyPrint } = winston.format;
    const logPath = 'logs/kasu-package';
    const statisticsTransport = new DailyRotateFile({
        filename: `${logPath}/%DATE%/statistics-%DATE%.log`,
        datePattern: 'DD-MM-YYYY',
        level: 'statistics',
        json: true,
    });
    exports.statisticsTransport = statisticsTransport;
    const infoTransport = new DailyRotateFile({
        filename: `${logPath}/%DATE%/info-%DATE%.log`,
        datePattern: 'DD-MM-YYYY',
        level: 'info',
        format: prettyPrint(),
        json: true,
    });
    exports.infoTransport = infoTransport;
    const errorTransport = new DailyRotateFile({
        filename: `${logPath}/%DATE%/error-%DATE%.log`,
        datePattern: 'DD-MM-YYYY',
        format: prettyPrint(),
        json: true,
        level: 'error',
    });
    exports.errorTransport = errorTransport;
    const debugTransport = new DailyRotateFile({
        filename: `${logPath}/%DATE%/debug-%DATE%.log`,
        datePattern: 'DD-MM-YYYY',
        format: prettyPrint(),
        json: true,
        level: 'debug',
    });
    exports.debugTransport = debugTransport;
    const messagesTransport = new DailyRotateFile({
        filename: `${logPath}/message.log`,
        level: 'message',
        frequency: '24h',
        maxFiles: 1,
        eol: "\r\n"
    });
    exports.messagesTransport = messagesTransport;
});
