# Модуль Взаимодействие КСО(клиента) c КАСУ(сервером)

> Версия: 0.1.41

---

## Описание:

> Модуль предназначен для комплексного взаимодействия клиента - КСО и сервера КАСУ.

## Структура:

- example содержит простое electron приложение и необходимые файлы для демонстрации работы модуля.

* ### Посмотреть пример работы пакета:
1. Установить пакет: npm install @neuro-city/lukoil-kasu;
2. Перейти в корневую директорию модуля ;
3. Выполнить npm i;
4. Перейти в директорию запуска примера работы модуля lukoil-kasu/example;
5. Выполнить npm i;
6. Запустить пример: npm run start;
* ### Подключить пакет к проекту:
1.  Установить пакет: npm install @neuro-city/lukoil-kasu;
2.  Создать переменную пакета const lukoil-kasu = require('@neuro-city/lukoil-kasu');

## Интерфейс:

- ### Команды:

1.  connect - Команда для установления websocket соединения и получения всех первичных и основных данных , кроме меню, принимает параметры:
- urlWs - string, адрес websocket соединения.
- ClientProgramValue - string, название ClientProgram для headers.
- ClientNameValue - string название ClientName для headers.
2. on - Подписка на события модуля, принимает параметры:
- string, тип события, доступные:
  - 'error' - ошибка при работе модуля.
  - 'info' - информация о работе модуля.
  - \*Различные подписки, подробности в примечании.
  - callback-функция, выполняющаяся при событии.
3.  fetchMenuKASU - Команда для установления http соединения и получения меню, принимает параметр:
- urlHttp - string, адрес http соединения.
4.  addProductToCart - Команда для добавления продукта из меню КСО в корзину, принимает параметры:
- productId - number, externalId из объекта меню, а именно productGroups.products.externalId.
- price - number, цена продукта из объекта меню, а именно productGroups.products.price.value .
5.  addProductScan - Команда для добавления продукта из меню КСО в корзину с помощью скан, принимает параметр:
- code - number, значение просканированного кода.
6.  fpLock - Команда для блокировки ТРК(топливной колонки), принимает параметры:
- fpId - number, значение идентификатор стороны ТРК.
- lockId - number, значение идентификатор POS, который заблокировал ТРК.
- nozzleId - number, значение идентификатор пистолета ТРК.
7.  fpUnlock - Команда для разблокировки ТРК(топливной колонки), принимает параметры:
- fpId - number, значение идентификатор стороны ТРК.
- lockId - number, значение идентификатор POS, который заблокировал ТРК.
- nozzleId - number, значение идентификатор пистолета ТРК.
8.  addPostPayFuel - Команда для постоплатного налива, принимает параметр:
- fpId - number, значение идентификатор стороны ТРК.
9.  addPostPayFuel - Команда для предоплатного налива, принимает параметры:
- nozzleId - number, значение идентификатор пистолета ТРК.
- isFuellingInMoney - boolean, true если заказ будет на сумму, false – если на литры.
- quantity - number, кол-во единиц налива (если в isFuellingInMoney - true, то это кол-во единиц в деньгах, если false, то в литрах, сумма в модуле подсчитается и подставиться при отправке на сервер автоматически).
10. deleteProduct - Команда для удаления товара, принимает параметр:
- chequeLineId - number, значение идентификатор строки заказа (берётся из basketUpdate.cheque/lines/[line]/id)
11. cancelOrder - Команда для отмены всего заказа (очищает корзину), метод без параметров.
12. acceptOrder - Команда для подтверждения заказа, принимает параметры:
- clientPhoneNumber - string, значение номера телефона для отправки СМС с чеком.
- beeperNumber - string, true значение номера бипера.
- takeAway - boolean, true если заказ с собой, false, если нет.
13. startPay - Команда для отправки на сервер параметров оплаты заказа, принимает параметры:
- sellingTypeId - number, 0 – при оплате банковской или топливной картой
  {id} – при оплате СБП, приходит в fpConfig.
- applayDiscount - boolean, true если необходимо применить карту лояльности, false, если нет.
- isLicardCard - boolean, true если оплата топливной картой, false, если нет.
- loyaltyCardNumber - Номер карты лояльности, запрошенной ранее через qr-код.
- loyaltyRequestType - Способ считывания qr-кода: 0 – неизвестно, 1 - сканер, 2 – терминал.

14. processQrLoyalty -* Функция для отправки на сервер сообщение о применении карты лояльности с QR кодом или clientId

        { qrCode?: string; idClient?: string } // QR код карты лояльности или clientIdm
15. pressedButton - Команда для отправки на сервер нажатой кнопки(не/подтверждающий списание баллов), принимает параметр:
- pressButton - string, наименование кнопки (btnYes - да, btnNo - нет).
  *Получение кнопок смотреть п. 18*
16. loyaltyOtpCode - Команда для отправки на сервер сообщения с введённым кодом (на списание баллов карты лояльности), принимает параметр с необязательными полями:
```typescript
{ 
  pressedButtons?: "btnBack" | "btnResendOTP" | "btnContinue"; 
  otpCode?: number 
}
```

17. getClientData - Метод для запроса данных клиента , принимает параметр:
- qrCode - string, qr-код лояльности
18. getLoyaltyButtons - Метод для запроса массива кнопок:
19. getDataModule - Команда для получения объект со всеми данными, без параметров, помимо получения данных с КАСУ по средствам подписок, внутри модуля в объект dataModule, записываются все данные с КАСУ, объект представляет из себя:
- menuCafeServiceData: Объект с меню кафе;
- imagesDataAllData: Массив со списком изображений два типа(type) изображение(1 – группы, 2 - товара);
- settingsDataStructureData: Объект с объектом pos, внутри имя и идентификатор КСО;
- fuelStationDataData: Объект с двумя свойствами - fps и tankProducts (два массива, в первом перечисляются колонки (id и массив с пистолетами), во втором баки с топливом (объекты с описанием бака));
- optionsDataStructureData: Объект с различными таймаутами(отображения окна с сообщением, отображения сообщения, отображения краткого сообщения, ожидания действий пользователя, сообщения “Продолжить ожидание?”) и кол-ва биперов;
- informationMessageFromKSO: Переменная, куда записываются информационные сообщения от сервера;
- remainingTimeValue: Переменная с информацией о остатки времени в секундах, после которого можно запросить код повторно;
- confirmationPointsDebiting: Переменная с извещением о введением неверного кода подтверждения списания баллов;
- answerButtons: Массив с кнопками (btnYes, btnNo);
- arrStateTRK: Массив с объектами, внутри которых состояние ТРК(колонки);
- acceptOrderValue: Подтверждение заказа (true/false);
- valueFuel: Текущие значение(id) снятого пистолета;
- basketValue: Объект с состоянием корзины;
20. getClient - Команда для запроса полученных с КАСУ данных о пользователе
21. cancelOrderAndRecoverBasket - Функция для удаления топлива из корзины, и восстановления остальных товаров в корзине
22. resetTransaction - Функция для отмены ожидания сканирования qr

- ### Примечание

* Помимо подписок на info и error, у нас есть подписки на получения данных от КАСУ по средствам EventEmmiter, вот все подписки:

- Подписываемся на получение меню
  KSOModule.on('menuData', (info) => {
  // Манипуляция с данными меню
  });

- Подписываемся на получения подтверждения на оплату чека
  KSOModule.on('paymentSuccessful', () => {
  // Выполняем действия после подтверждения на оплату чека
  });

- Подписываемся на получения подтверждения о сформирования заказа и получения номера заказа
  KSOModule.on('acceptOrderCheck', (order) => {
  // Получем номер заказа - order
  });

- Подписываемся на получения информационных сообщений для взаимодействия с клиентом
  KSOModule.on('arrivalMessage', (message) => {
  // Вывод сообщения message
  });

- Подписываемся на получения массива с кнопками (списывать или нет баллы)
  KSOModule.on('arrivalMessage', (buttonsArr) => {
  // Манипуляция с кнопками из buttonsArr
  });

- Подписываемся на получения сообщения ввести проверочный код + номер телефона (куда придёт)
  KSOModule.on('arrivalOtpCode', (message) => {
  // Вывод сообщения message
  });

- Подписываемся на получения сообщения с данными клиента (id – карты лояльности)
  KSOModule.on('callbackClientData', (message) => {
  // Вывод сообщения message
  });

- Подписываемся на получения сообщения о том, что введён не правильный проверочный код (на списание баллов)
  KSOModule.on('informationMessageFromKSO', (message) => {
  // Вывод сообщения message
  });

- Подписываемся на получения сообщения с остатком времени в секундах, после которого можно запросить код повторно
  KSOModule.on('arrivalOtpTimerValue', (message) => {
  // Вывод сообщения message с кол-во секунд
  });

- Подписываемся на событие получения картинок с товарами
  KSOModule.on('imagesDataAll', (imagesDataAllData) => {
  // Выполняем действия с картинками из imagesDataAllData
  });

- Подписываемся на событие получения подтверждения доступности/недоступности сервиса КАСУ
  KSOModule.on('serviceAvailableCheck', (serviceFlag) => {
  return serviceFlag ? console.log('Сервис доступен') : console.log('Сервис недоступен')
  });

- Подписываемся на событие получения конфигурации КСО
  KSOModule.on('stationConfig', (stationConfigData) => {
  // Выполняем действия с stationConfigData;
  });

- Подписываемся на событие получения конфигурации ТРК (все колонки и баки с топливом)
  KSOModule.on('fpConfig', (fpConfigData) => {
  // Выполняем действия с fpConfigData
  });

- Подписываемся на событие получения настроек АЗС (различные таймауты, кол-во биперов и тд)
  KSOModule.on('optionsUpdate', (options) => {
  // Выполняем действия с options
  });

- Подписываемся на событие получения состояний ТРК (реализованно собирания их в общий массив)
  KSOModule.on('fpStatus', () => {
  fpStatusData = KSOModule.getDataModule().arrStateTRK;
  // Выполняем действия с KSOModule.getDataModule().arrStateTRK(подтягиваем состояния всех колонок из модуля)
  });

- Подписываемся на событие получения данных о корзине и на основе его полей создание карточек в корзине
  KSOModule.on('basketUpdate', (basketUpdateData) => {
  // Выполняем действия с basketUpdateData;
  });
- 
- Подписываемся на событие showMessageWindow (информационных сообщений из касу)
  KSOModule.on('showMessageWindow', (showMessageWindowData) => {
  // Выполняем действия с basketUpdateData;
  });
