const { errorEmit, dataEmit, connectEmit, disconnectEmit, statusChangedEmit } = require('../events');

// Функция для отправки команды «configdata(<data_pin>, <clock_pin>)»
const sendConfigInitializeCommand = (arg, arduino) => {
    if (arduino && arduino.isOpen) {
      hexColor = normalizeHexColor(arg.idleColor)
      if (!hexColor) {
        errorEmit(`Неверный формат цвета: ${arg.idleColor}`);
        return;
    }
      const configDataCommand = arg.enableRGBPin ? `configdata(${arg.redPin}, ${arg.greenPin}, ${arg.bluePin}, ${hexColor})` : `configdata(${arg.dataPin}, ${arg.clockPin}, ${hexColor})`;
      arduino.write(configDataCommand, (error) => {
        if (error) {
          errorEmit(`Ошибка при отправке команды configdata: ${error.message}`);
        } else {
          const params = arg.enableRGBPin
            ? `<red_pin> — ${arg.redPin}, <green_pin> — ${arg.greenPin}, <blue_pin> — ${arg.bluePin}`
            : `<data_pin> — ${arg.dataPin}, <clock_pin> — ${arg.clockPin}`;
          dataEmit(`Отправлена команда configdata с параметрами: ${params}, <idleColor> — ${arg.idleColor}`);
        }
      });
    } else {
      errorEmit('Arduino порт не открыт. Пожалуйста, подключитесь к порту перед отправкой команды configdata.');
      return false
    }
};

// Функция для вызова сценариев свечения светодиодной ленты
const sendCommand = (commandType, arg, arduino) => {
    if (arduino && arduino.isOpen) {
        let hexColor = normalizeHexColor(arg.hexColor);
        let hexColor2 = null
        if (!hexColor) {
            errorEmit(`Неверный формат цвета: ${arg.hexColor}`);
            return;
        }

        let command = null;
        switch(commandType) {
            case 'dimmer':
                command = `dimmer(${hexColor}, ${arg.speed})`;
                break;
            case 'blink':
                hexColor2 = normalizeHexColor(arg.hexColor2);
                if (!hexColor2) {
                    errorEmit(`Неверный формат второго цвета: ${arg.hexColor2}`);
                    return;
                }
                command = `blink(${hexColor}, ${hexColor2}, ${arg.speed})`;
                break;
            case 'staticlighting':
                command = `staticlighting(${hexColor})`;
                break;
            case 'smoothtransition':
                hexColor2 = normalizeHexColor(arg.hexColor2);
                if (!hexColor2) {
                  errorEmit(`Неверный формат второго цвета: ${arg.hexColor2}`);
                    return;
                }
                command = `smoothtransition(${hexColor}, ${hexColor2}, ${arg.speed})`;
                break;
            case 'pulse':
                command = `pulse(${hexColor}, ${arg.duration})`;
                break;
            default:
                errorEmit(`Неизвестная команда: ${commandType}`);
                return;
        }
        arduino.write(command, (error) => {
          if (error) {
              errorEmit(`Ошибка при отправке команды: ${error.message}`);
          } else {
              dataEmit(`Отправлена команда: тип — ${commandType}, параметры — ${JSON.stringify(arg)}`);
          }
      });
    } else {
        errorEmit('Arduino порт не открыт. Пожалуйста, подключитесь к порту перед отправкой команды.');
        return false
    }
};

const normalizeHexColor = (hexColor) => {
    // Убираем символ '#' в начале, если он есть
    if (hexColor.startsWith('#')) {
      hexColor = hexColor.slice(1);
    }
    // Проверяем длину строки
    return hexColor.length <= 6 ? hexColor : false;
};

module.exports = {
    sendConfigInitializeCommand,
    sendCommand
}