const EventEmitter = require('events');
const emitter = new EventEmitter();

// Функции для генерации событий
const connectEmit = (open) => {
  emitter.emit('open', open);
};

const disconnectEmit = (close) => {
  emitter.emit('close', close);
};

const errorEmit = (error) => {
  emitter.emit('error', error);
};

const dataEmit = (data) => {
  emitter.emit('data', data);
};

const statusChangedEmit = (statusObject) => {
  emitter.emit('status-changed', statusObject);
};

module.exports = {
  connectEmit,
  disconnectEmit,
  errorEmit,
  dataEmit,
  statusChangedEmit,
  emitter
};
