const { errorEmit, dataEmit, connectEmit, disconnectEmit, statusChangedEmit } = require('../events');

// Проверка параметов конфига arduino
const checkArduinoConfig = (arduinoConfig) => {
    if (!arduinoConfig || typeof arduinoConfig !== 'object') {
      errorEmit('Некорректная конфигурация Arduino. Ожидается объект.');
      return false;
    }
    if (typeof arduinoConfig.project !== 'string' || arduinoConfig.project.trim().length === 0) {
      errorEmit('Некорректное значение для названия проекта');
      return false;
    }
    if (typeof arduinoConfig.idleColor !== 'string' || !/^#[0-9A-Fa-f]{6}$/.test(arduinoConfig.idleColor)) {
      errorEmit('Некорректное значение для color_Wait. Ожидается строка в формате HEX.');
      return false;
    }
    const reconnectIntervalValue = Number(arduinoConfig.reconnectIntervalValue);
    if (isNaN(reconnectIntervalValue) || reconnectIntervalValue < 0) {
      errorEmit('Некорректное значение для reconnectInterval. Ожидается положительное число.');
      return false;
    }
    if (typeof arduinoConfig.port !== 'string' || arduinoConfig.port.trim().length === 0) {
        errorEmit('Некорректное значение для порта. Ожидается непустая строка.');
        return false;
    }
    const dataPin = Number(arduinoConfig.dataPin);
    if (isNaN(dataPin) || !Number.isInteger(dataPin) || dataPin < 0 || dataPin > 13) {
    errorEmit('Некорректное значение для dataPin. Ожидается целое число от 0 до 13.');
    return false;
    }
    const clockPin = Number(arduinoConfig.clockPin);
    if (isNaN(clockPin) || !Number.isInteger(clockPin) || clockPin < 0 || clockPin > 13) {
    errorEmit('Некорректное значение для clockPin. Ожидается целое число от 0 до 13.');
    return false;
    }
    return true;
  };

  module.exports = { checkArduinoConfig };