# Описание каркасно-модульной ситемы разработки приложений #

- - -

## Ссылки:
- [Проект в Jira](https://akziagroup.atlassian.net/jira/software/c/projects/MOD/boards/83)
- [Репозиторий проекта](https://bitbucket.org/newdanver/frame-modular-system/src/master/)
- [Neuro-Wiki](https://wiki.neuro-city.ru/index.php?title=%D0%9E%D1%82%D0%B4%D0%B5%D0%BB_%D0%BF%D1%80%D0%BE%D0%B3%D1%80%D0%B0%D0%BC%D0%BC%D0%BD%D0%BE%D0%B3%D0%BE_%D0%BE%D0%B1%D0%B5%D1%81%D0%BF%D0%B5%D1%87%D0%B5%D0%BD%D0%B8%D1%8F)

## Содержание:

* [1. Модули](#markdown-header-1)
	* [1.1 Структура и правила ведения проекта](#markdown-header-11)
	* [1.2 Првила создания и разработки модуля](#markdown-header-12)
	* [1.3 Структура модуля](#markdown-header-13)
	* [1.4 Версионность и публикация модуля](#markdown-header-14)
* [2. Каркас](#markdown-header-2)
	
- - -

# 1. Модули:

## 1.1 Структура и правила ведения проекта
* ### Структура репозитория:
	* **master** - основная ветка проекта, содержит все завершённые и опубликованные модули;
	* **clean** - содержит заготовку для нового модуля и последнюю версию описания проекта;
	* **readme** - содержит последнюю версию описания проекта;
	* **group/module** - ветка модуля, где `group` - название группы в которой находтся модуль (common, devices и т.д.), а `module` - название модуля.
* ### Этапы жизни модуля:
	1. Создание: создание эпика модуля и отщипление ветки `group/module` из `clean`;
	1. Реализация: посатовка задач по созданию и доработки модуля в эпике и их решение в дочерних ветках из `group/module`;
	1. Сборка: тестирование, закрытие задач, мерж веток с решёнными задачами в `group/module` и финальное тестирование;
	1. Релиз: выпуск релиза в эпике и вмерживание в `group/module` ветки с новым релизом.
* ### Описание:
	* Все дополнения в описании руководства ведения проекта необходимо производить в файле "README.md" в ветке `readme` и мержить в ветку `clean`. По завершении описания ведения проекта, ветку `readme` можно примержить в `master`;
	* В корне каждого модуля должен храниться ["README.md"](#markdown-header-readmemd) с описанием модуля и инструкциями.

## 1.2 Правила создания и разработки модуля
* ### Руководителю проекта необходимо:
	1. Отщипить ветку `group/module` от ветки `clean`, где `group` - название группы в которой находтся модуль (common, devices и т.д.), а `module` - название модуля;;
	1. Создать в проекте эпик с именем `group/module` и резюме `Название группы: Название модуля`. Все задачи по разработке и доработки данного модуля необходимо привязывать к этому эпику;
	1. Переключиться на ветку`group/module`. _Примечание:_ в директории проекта должен находиться только файл "README.md" и папка "group" содержащая вложенную папку `module`. В `module` только три файла: "README.md", "package.json" и ".gitignore";
	1. Переименовать папки `group` и вложенную в неё `module` в соответствии с группой и названием модуля;
	1. Указать в файлах ["README.md"](#markdown-header-readmemd) и ["package.json"](#markdown-header-packagejson)` из папки модуля название нового модуля;
	1. Сделать `push` изменений, передать ссылки на ветку модуля (`git clone --branch group/module url module`) и эпик модуля разработчику.
	
* ### Разработчику модуля необходимо:
	1. Склонировать в папку с проектами ветку доверенного модуля;
	1. Ознакомиться с правилами разработки модуля;
	1. Отщиплять ветки для решения задач исключительно только от ветки модуля `group/module`;
	1. Перед выпуском релиза обязательно заполнить описание модуля в `group/module/README.md` и создать скрипт `example` для запуска примера работы модуля в `package.json`;
	
## 1.3. Структура модуля
* ### package.json
	* Наличие: обязательно;
	* Описание: описание и структуру можно изучить на [официальном сайте](https://docs.npmjs.com/cli/v7/configuring-npm/package-json);
	* Примечание:
		* Название модуля (поле `name`) должно содержать префикс `@neuro-city/`, т.е. иметь вид `@neuro-city/module`;
		* В разделе `scripts` должна быть описана команда `examle` для запуска примера работы модуля;
		* Автором модуля необходимо указывать `Neuro-City™` (поле `author`);
		* В разделе `directories` необходимо указать основные папки модуля с описанием;
* ### README.md
	* Наличие: обязательно;
	* Описание: содержит в себе описание модуля и инструкции по его подключению;
	* Структура:
		* Заголовок - содержит название модуля и его версию;
		* Структура - содержит описание назначения папок и файлов модуля;
		* Подключение - содержит описание запуска примера работы модуля и подключения к проекту;
		* Интерфейс - содержит описание функций (методов) для работы с модулем, а так же всех событий модуля;
	* Примечание:
		* Для удобства понимания и четения файла стоит пользоваться языками разметки, например [Markdown](https://www.markdownguide.org/);
* ### .gitignore
	* Наличие: обязательно;
	* Описание: содержит список игнорируемых для Git файлов и папок;
	* Примечание:
		* С правилами создания исключений можно ознакомиться [здесь](https://www.atlassian.com/ru/git/tutorials/saving-changes/gitignore);
* ### index.js
	* Наличие: обязательно;
	* Описание: основной скрипт через который проиходит подключение модуля;
* ### example/index.js
	* Наличие: обязательно;
	* Описание: скрипт показывающий работу модуля.

## 1.4 Версионность и публикация модуля

# 2. Каркас