function initExample() {
    initFeedbackTypeButtons();
}

function initFeedbackTypeButtons() {
    const feedbackButtons = document.querySelectorAll('.feedback-type-button');
    const feedbackContents = document.querySelectorAll('.feedback-form__content');
    feedbackButtons.forEach((button) => {
        button.addEventListener(('click'), () => {
            feedbackButtons.forEach((el) => el.classList.remove('active'));
            button.classList.add('active');

            const feedbackType = button.textContent[0].toLowerCase() + button.textContent.slice(1);
            feedbackContents.forEach((el) => {
                if (el.id.includes(`${feedbackType}-content`)) {
                    el.classList.remove('disabled');
                    return;
                }
                if (el.id.includes('content')) {
                    el.classList.add('disabled');
                }
            })
        })
    })
}

function createAndAddAudioEl(blobAudioEl, audioContainer) {
    const audioFeedback = new Audio;
    audioFeedback.controls = true;
    audioFeedback.src = URL.createObjectURL(blobAudioEl);
    audioContainer.innerHTML = "";
    audioContainer.appendChild(audioFeedback);
}

function createAndAddVideoEl(blobVideoEl, videoContainer) {
    const videoFeedback = document.createElement('video');
    videoFeedback.controls = true;
    videoFeedback.src = typeof blobVideoEl === 'string' ? blobVideoEl : URL.createObjectURL(blobVideoEl);
    videoContainer.innerHTML = "";
    videoContainer.appendChild(videoFeedback);
}

function createAndAddPhotoEl(imageBlob, photoContainer) {
    const image = new Image();
    image.src = URL.createObjectURL(imageBlob);
    photoContainer.innerHTML = "";
    photoContainer.appendChild(image);
}

module.exports = {
    initExample,
    createAndAddAudioEl,
    createAndAddVideoEl,
    createAndAddPhotoEl
};