import { emit } from '../../utils';

let newFields: string[] = [];

// объединяет конфиги
const syncConfigsEntry = (
  remoteConfig: DynamicObject,
  localConfig: DynamicObject,
  defaultConfig: DynamicObject,
  newFieldsArr: string[],
): DynamicObject => {
  if (!localConfig && !remoteConfig) {
    return defaultConfig;
  }

  newFields = newFieldsArr;
  newFields.length = 0;

  const synchronizedConfig = syncConfigsRecursion(
    localConfig || {},
    remoteConfig || {},
    defaultConfig || {},
  );

  emit('info', 'конфиги синхронизированы');

  return synchronizedConfig;
};

// рекурсивная синхронизация 3х конфигов
const syncConfigsRecursion = (
  localConfig: DynamicObject,
  remoteConfig: DynamicObject,
  defaultConfig: DynamicObject,
) => {
  const synchronizedConfig: DynamicObject = {};

  const config = { ...defaultConfig, ...localConfig, ...remoteConfig };

  Object.keys(config).forEach((key) => {
    synchronizedConfig[key] = config[key];

    if (typeof config[key].value === 'object' && !Array.isArray(config[key]?.value)) {
      synchronizedConfig[key].value = syncConfigsRecursion(
        localConfig[key]?.value || {},
        remoteConfig[key]?.value || {},
        defaultConfig[key]?.value || {},
      );
    }

    if (!localConfig[key] && remoteConfig[key]) {
      newFields.push(key);
    }
  });

  return synchronizedConfig;
};

export default syncConfigsEntry;
