import { emit } from '../../utils';

// создаёт экспортный конфиг без поле "name" и "value"
const parseConfigEntry = (config: DynamicObject) => {
  const parsedConfig = parseConfigRecursion(config);

  emit('info', 'конфиг для экспорта готов');

  return parsedConfig;
};

const parseConfigRecursion = (configLayer: DynamicObject) => {
  const parsedConfigLayer = {} as DynamicObject;

  for (const key in configLayer) {
    const value = configLayer[key].value;

    if (typeof value !== 'object' || Array.isArray(value)) {
      parsedConfigLayer[key] = value;
    } else {
      parsedConfigLayer[key] = parseConfigRecursion(value);
    }
  }

  return parsedConfigLayer;
};

export default parseConfigEntry;
