declare global {
  type DynamicObject = {
    [key: string]: any;
  };

  type Config = {
    default?: DynamicObject;
    local?: DynamicObject;
    remote?: DynamicObject;
    device: DynamicObject;

    united: DynamicObject;

    HTML: HTMLElement;
    parsed: DynamicObject;
    root: HTMLElement;
  };

  type InitProps = {
    appName: string;
    deviceConfigPath: string;
    defaultConfigPath: string;
    localConfigPath: string;
  };

  type Option = {
    value: string;
    name: string;

    chosen?: boolean;
    disabled?: boolean;
  };

  type ConfigEvents = 'info' | 'error' | 'warn' | 'ready' | 'open' | 'close' | 'saved';
}

export {};
