'use strict';
var __createBinding =
  (this && this.__createBinding) ||
  (Object.create
    ? function (o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (
          !desc ||
          ('get' in desc ? !m.__esModule : desc.writable || desc.configurable)
        ) {
          desc = {
            enumerable: true,
            get: function () {
              return m[k];
            },
          };
        }
        Object.defineProperty(o, k2, desc);
      }
    : function (o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        o[k2] = m[k];
      });
var __setModuleDefault =
  (this && this.__setModuleDefault) ||
  (Object.create
    ? function (o, v) {
        Object.defineProperty(o, 'default', { enumerable: true, value: v });
      }
    : function (o, v) {
        o['default'] = v;
      });
var __importStar =
  (this && this.__importStar) ||
  function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null)
      for (var k in mod)
        if (k !== 'default' && Object.prototype.hasOwnProperty.call(mod, k))
          __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
  };
Object.defineProperty(exports, '__esModule', { value: true });
exports.readRemoteConfig =
  exports.createElement =
  exports.cloneObject =
  exports.sendRemoteConfig =
  exports.getRemoteDeviceConfigUrl =
  exports.readConfig =
  exports.emit =
  exports.errorEmit =
  exports.readyEmit =
  exports.emitter =
    void 0;
const fs = __importStar(require('fs'));
const events_1 = require('events');
exports.emitter = new events_1.EventEmitter();
exports.emitter.setMaxListeners(0);
const readyEmit = (config) => {
  exports.emitter.emit('ready', '[config] [ready] конфиг готов к работе', config);
};
exports.readyEmit = readyEmit;
const errorEmit = (error) => {
  exports.emitter.emit('ready', '[config] [ready] произошла ошибка', error);
};
exports.errorEmit = errorEmit;
const emit = (event, message, config) => {
  exports.emitter.emit(event, `[config] [${event}] ${message}`, config);
};
exports.emit = emit;
// функция чтения конфига
const readConfig = (path, successEmit, errorEmit, notFoundEmit, emptyEmit) => {
  if (fs.existsSync(path)) {
    try {
      const data = fs.readFileSync(path, { encoding: 'utf-8' });
      let parsedData;
      if (!data || !JSON.parse(data)) {
        emptyEmit();
        parsedData = {};
      } else {
        parsedData = JSON.parse(data);
        successEmit();
      }
      return parsedData;
    } catch (err) {
      errorEmit();
      console.error(err);
    }
  } else {
    notFoundEmit();
  }
  return;
};
exports.readConfig = readConfig;
// билдер ссылки для чтения удалённого конфига
const getRemoteDeviceConfigUrl = (url, id) => {
  return `http://${url}/devices/config/${id}`;
};
exports.getRemoteDeviceConfigUrl = getRemoteDeviceConfigUrl;
// заготовка для функции отправки конфига на сервер
const sendRemoteConfig = async (url, deviceId, config) => {
  try {
    const res = await fetch((0, exports.getRemoteDeviceConfigUrl)(url, deviceId), {
      method: 'PUT',
      body: JSON.stringify(config),
    });
    (0, exports.emit)('info', 'конфиг отправлен на сервер');
    return await res.json();
  } catch (err) {
    (0, exports.emit)('error', 'не удалось отправить конфиг на сервер');
    console.error(err);
  }
  return;
};
exports.sendRemoteConfig = sendRemoteConfig;
// клонирует объект с любым уровнем вложенности
const cloneObject = (object) => JSON.parse(JSON.stringify(object));
exports.cloneObject = cloneObject;
// функция создания любого элемента HTML
const createElement = (tagName, options, parent, children) => {
  const element = document.createElement(tagName);
  if (options) {
    Object.keys(options).forEach((k) => {
      const key = k;
      element[key] = options[key];
    });
  }
  if (parent) {
    parent.appendChild(element);
  }
  if (children) {
    if (!Array.isArray(children)) {
      children = [children];
    }
    element.append(...children);
  }
  return element;
};
exports.createElement = createElement;
// читает удалённый конфиг
const readRemoteConfig = async (config, configUrl) => {
  if (!configUrl && !config.device._id) {
    (0, exports.emit)(
      'warn',
      `не найден ${configUrl ? 'id устройства' : 'url'} для получения удаленного конфига`,
    );
    return;
  }
  if (!shouldLoadRemoteConfig(config)) {
    (0, exports.emit)('info', 'запрос удаленного конфига отключен');
    return;
  }
  let remoteConfig;
  try {
    const url = (0, exports.getRemoteDeviceConfigUrl)(configUrl, config.device._id);
    const res = await fetch(url, { method: 'GET' });
    (0, exports.emit)('info', 'удаленный конфиг прочитан');
    remoteConfig = await res.json();
  } catch (err) {
    (0, exports.emit)('error', 'произошла ошибка при попытке получить удаленный конфиг');
    console.error(err);
  }
  return remoteConfig;
};
exports.readRemoteConfig = readRemoteConfig;
// проверяет, есть ли поле data_request_from_ad, по значению которого определяется
// и добавляет его, если оно отсутствует
// проверяет в локальном и дефолтном конфиге
const shouldLoadRemoteConfig = (config) => {
  var _a, _b, _c, _d, _e;
  if (
    config.default &&
    typeof ((_a = config.default) === null || _a === void 0
      ? void 0
      : _a.data_request_from_ad) !== 'object'
  ) {
    config.default.data_request_from_ad = {
      name: 'Загружать конфиг с сервера',
      value: false,
    };
  }
  if (
    config.local &&
    typeof ((_b = config.local) === null || _b === void 0
      ? void 0
      : _b.data_request_from_ad) !== 'object'
  ) {
    if (
      (_c = config === null || config === void 0 ? void 0 : config.default) === null ||
      _c === void 0
        ? void 0
        : _c.data_request_from_ad
    ) {
      config.local.data_request_from_ad = config.default.data_request_from_ad;
    } else {
      config.local.data_request_from_ad = {
        name: 'Загружать конфиг с сервера',
        value: false,
      };
    }
  }
  return (_e =
    (_d = config === null || config === void 0 ? void 0 : config.local) === null ||
    _d === void 0
      ? void 0
      : _d.data_request_from_ad) === null || _e === void 0
    ? void 0
    : _e.value;
};
//# sourceMappingURL=utils.js.map
