'use strict';
var __createBinding =
  (this && this.__createBinding) ||
  (Object.create
    ? function (o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (
          !desc ||
          ('get' in desc ? !m.__esModule : desc.writable || desc.configurable)
        ) {
          desc = {
            enumerable: true,
            get: function () {
              return m[k];
            },
          };
        }
        Object.defineProperty(o, k2, desc);
      }
    : function (o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        o[k2] = m[k];
      });
var __setModuleDefault =
  (this && this.__setModuleDefault) ||
  (Object.create
    ? function (o, v) {
        Object.defineProperty(o, 'default', { enumerable: true, value: v });
      }
    : function (o, v) {
        o['default'] = v;
      });
var __importStar =
  (this && this.__importStar) ||
  function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null)
      for (var k in mod)
        if (k !== 'default' && Object.prototype.hasOwnProperty.call(mod, k))
          __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
  };
var __importDefault =
  (this && this.__importDefault) ||
  function (mod) {
    return mod && mod.__esModule ? mod : { default: mod };
  };
Object.defineProperty(exports, '__esModule', { value: true });
const fs = __importStar(require('fs'));
const styleNames_1 = __importDefault(require('../../styleNames'));
const utils_1 = require('../../utils');
const index_1 = require('../../../index');
const parseConfig_1 = __importDefault(require('../parseConfig/parseConfig'));
let shouldSaveDefaultConfig = false;
// собирает новый конфиг из HTML страницы и сохраняет его
const saveConfigEntry = ({ config, pathToSaveLocalConfig, pathToSaveDefaultConfig }) => {
  const configPage = config.HTML;
  let isConfigChanged = configPage.dataset.isChanged === 'true';
  if (isConfigChanged) {
    configPage.dataset.isChanged = 'false';
    const newConfig = saveConfigRecursion(
      configPage.getElementsByClassName(styleNames_1.default.highestNode)[0],
      config.default,
    );
    if (pathToSaveLocalConfig) {
      writeConfig(
        pathToSaveLocalConfig,
        newConfig,
        'не удалось перезаписать локальный конфиг',
      );
    }
    if (shouldSaveDefaultConfig) {
      writeConfig(
        pathToSaveDefaultConfig,
        config.default,
        'не удалось перезаписать дефолтный конфиг',
      );
    }
    isConfigChanged = false;
    config.parsed = (0, parseConfig_1.default)(newConfig);
    (0, utils_1.emit)('saved', 'изменённый конфиг сохранён', config.parsed);
    (0, index_1.close)();
    return newConfig;
  } else {
    (0, utils_1.emit)('info', 'нет изменений, чтобы их сохранить');
    (0, index_1.close)();
  }
};
const saveConfigRecursion = (parentNode, defaultConfig) => {
  var _a, _b;
  const configLayer = {};
  for (let i = 0; i < parentNode.children.length; i++) {
    const child = parentNode.children[i];
    const key = child.children[0].dataset.key || '';
    const saveInDefault = child.children[0].dataset.saveInDefault || '';
    if (child.classList.contains(styleNames_1.default.inputNode)) {
      configLayer[key] = {};
      configLayer[key].name =
        (_a = child.querySelector(
          `.${styleNames_1.default.nodeDescription} .${styleNames_1.default.nodeName}`,
        )) === null || _a === void 0
          ? void 0
          : _a.textContent;
      const valueInput = child.querySelector('input');
      if (!valueInput) {
        const valueSelect = child.querySelector('select');
        if (valueSelect) {
          configLayer[key].value = Array.from(valueSelect.options).map((option) => {
            return {
              name: option.textContent,
              value: option.value,
              chosen: option.selected,
            };
          });
        }
      } else {
        switch (valueInput.type) {
          case 'checkbox': {
            configLayer[key].value = valueInput.checked;
            break;
          }
          case 'number': {
            configLayer[key].value = Number(valueInput.value);
            configLayer[key].type = valueInput.step.includes('.') ? 'float' : 'integer';
            configLayer[key].step = valueInput.step;
            break;
          }
          case 'text': {
            configLayer[key].value = valueInput.value;
            break;
          }
        }
      }
      if (typeof configLayer[key].value !== 'number' && configLayer[key].type) {
        delete configLayer[key].type;
      }
    } else if (child.classList.contains(styleNames_1.default.node)) {
      configLayer[key] = {
        name: child.children[0].getElementsByTagName('span')[0].textContent,
        value: saveConfigRecursion(
          child,
          defaultConfig
            ? (_b = defaultConfig[key]) === null || _b === void 0
              ? void 0
              : _b.value
            : undefined,
        ),
      };
    }
    if (defaultConfig && saveInDefault) {
      if (!defaultConfig[key]) {
        defaultConfig[key] = {};
      }
      shouldSaveDefaultConfig = true;
      if (saveInDefault.includes('name')) {
        defaultConfig[key].name = configLayer[key].name;
      }
      if (saveInDefault.includes('key')) {
        defaultConfig[key].key = configLayer[key].key;
      }
      if (saveInDefault.includes('value')) {
        defaultConfig[key].value = configLayer[key].value;
        if (configLayer[key].type) {
          defaultConfig[key].type = configLayer[key].type;
        }
        if (configLayer[key].step) {
          defaultConfig[key].step = configLayer[key].step;
        }
      }
    }
  }
  if (defaultConfig) {
    const keys = Object.keys(configLayer);
    const propsToDeleteInDefault = Object.keys(defaultConfig).filter(
      (key) => !keys.includes(key),
    );
    if (propsToDeleteInDefault.length > 0) {
      shouldSaveDefaultConfig = true;
      propsToDeleteInDefault.forEach((key) => delete defaultConfig[key]);
    }
  }
  return configLayer;
};
const writeConfig = (path, config, emitMessage) => {
  try {
    fs.writeFileSync(path, JSON.stringify(config, null, '\t'));
  } catch (err) {
    console.error(err);
    (0, utils_1.emit)('error', emitMessage);
  }
};
exports.default = saveConfigEntry;
//# sourceMappingURL=saveConfigPage.js.map
