'use strict';
Object.defineProperty(exports, '__esModule', { value: true });
const utils_1 = require('../../utils');
// создаёт экспортный конфиг без поле "name" и "value"
const parseConfigEntry = (config) => {
  const parsedConfig = parseConfigRecursion(config);
  (0, utils_1.emit)('info', 'конфиг для экспорта готов');
  return parsedConfig;
};
const parseConfigRecursion = (configLayer) => {
  const parsedConfigLayer = {};
  for (const key in configLayer) {
    const value = configLayer[key].value;
    if (typeof value !== 'object' || Array.isArray(value)) {
      parsedConfigLayer[key] = value;
    } else {
      parsedConfigLayer[key] = parseConfigRecursion(value);
    }
  }
  return parsedConfigLayer;
};
exports.default = parseConfigEntry;
//# sourceMappingURL=parseConfig.js.map
