'use strict';
var __createBinding =
  (this && this.__createBinding) ||
  (Object.create
    ? function (o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (
          !desc ||
          ('get' in desc ? !m.__esModule : desc.writable || desc.configurable)
        ) {
          desc = {
            enumerable: true,
            get: function () {
              return m[k];
            },
          };
        }
        Object.defineProperty(o, k2, desc);
      }
    : function (o, m, k, k2) {
        if (k2 === undefined) k2 = k;
        o[k2] = m[k];
      });
var __setModuleDefault =
  (this && this.__setModuleDefault) ||
  (Object.create
    ? function (o, v) {
        Object.defineProperty(o, 'default', { enumerable: true, value: v });
      }
    : function (o, v) {
        o['default'] = v;
      });
var __importStar =
  (this && this.__importStar) ||
  function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null)
      for (var k in mod)
        if (k !== 'default' && Object.prototype.hasOwnProperty.call(mod, k))
          __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
  };
var __importDefault =
  (this && this.__importDefault) ||
  function (mod) {
    return mod && mod.__esModule ? mod : { default: mod };
  };
Object.defineProperty(exports, '__esModule', { value: true });
exports.sortComparator =
  exports.createSubmitDeleteModal =
  exports.showInvalidInputs =
  exports.createConfigControlButton =
    void 0;
const path = __importStar(require('path'));
const styleNames_1 = __importDefault(require('../../../styleNames'));
const utils_1 = require('../../../utils');
// создаёт кнопки изменения конфига и кнопку "свернуть всё"
const createConfigControlButton = ({ type, parent, onClick }) => {
  const svg = (0, utils_1.createElement)('img', {
    src: path.join(__dirname, '../../../..', `assets/${type}.svg`),
    alt: type,
  });
  return (0, utils_1.createElement)(
    'button',
    {
      className: (type !== 'collapseAll'
        ? styleNames_1.default.devButton + ' '
        : ''
      ).concat(styleNames_1.default[`${type}Button`]),
      onclick: onClick,
    },
    parent,
    svg,
  );
};
exports.createConfigControlButton = createConfigControlButton;
const showInvalidInputs = (wrapper) => {
  const highestNode = wrapper.querySelector(`.${styleNames_1.default.highestNode}`);
  highestNode === null || highestNode === void 0
    ? void 0
    : highestNode
        .querySelectorAll('details[open]')
        .forEach((details) => (details.open = false));
  highestNode === null || highestNode === void 0
    ? void 0
    : highestNode.querySelectorAll(':invalid').forEach((node) => {
        let parent = node.parentElement;
        while (parent && parent !== highestNode) {
          if (parent.nodeName === 'DETAILS') {
            parent.open = true;
          }
          parent = parent.parentElement;
        }
      });
};
exports.showInvalidInputs = showInvalidInputs;
// модальное окно, появляется при нажатии на кнопку удаления поля
const createSubmitDeleteModal = (configHTML, deletingNode) => {
  var _a, _b;
  const layout = (0, utils_1.createElement)(
    'div',
    {
      className: styleNames_1.default.modalLayout,
      onclick: (e) => {
        if (!e.composedPath().includes(modalSubmit)) {
          layout.remove();
        }
      },
    },
    configHTML,
  );
  const modalSubmit = (0, utils_1.createElement)(
    'div',
    { className: styleNames_1.default.modalSubmitDelete },
    layout,
  );
  (0, utils_1.createElement)(
    'p',
    {
      innerHTML: `Подтвердите удаление.${
        deletingNode.nodeName === 'DETAILS'
          ? '<br />Также удалятся все дочерние поля.'
          : ''
      }${
        ((_a = deletingNode.parentElement) === null || _a === void 0
          ? void 0
          : _a.children.length) === 2 &&
        !((_b = deletingNode.parentElement) === null || _b === void 0
          ? void 0
          : _b.classList.contains(styleNames_1.default.highestNode))
          ? '<br />Пустые разделы будут удалены.'
          : ''
      }`,
      className: styleNames_1.default.modalText,
    },
    modalSubmit,
  );
  const buttonsContainer = (0, utils_1.createElement)(
    'div',
    { className: styleNames_1.default.modalButtons },
    modalSubmit,
  );
  (0, utils_1.createElement)(
    'button',
    {
      onclick: () => {
        configHTML.dataset.isChanged = 'true';
        let parent = deletingNode.parentElement;
        const highestNode = document.querySelector(
          `.${styleNames_1.default.highestNode}`,
        );
        deletingNode.remove();
        while (parent && parent !== highestNode && parent.children.length === 1) {
          const tmp = parent.parentElement;
          parent.remove();
          parent = tmp;
        }
        layout.remove();
      },
      innerHTML: 'Удалить',
    },
    buttonsContainer,
  );
  (0, utils_1.createElement)(
    'button',
    { onclick: () => layout.remove(), innerHTML: 'Отменить' },
    buttonsContainer,
  );
};
exports.createSubmitDeleteModal = createSubmitDeleteModal;
const sortComparator = (textA, textB) => {
  if (textA && textB) {
    if (textA > textB) {
      return 1;
    } else if (textA < textB) {
      return -1;
    }
  }
  return 0;
};
exports.sortComparator = sortComparator;
//# sourceMappingURL=helpers.js.map
