# Модуль конфигурации приложения

> Версия: 2.1.0

---

## Описание:

> Модуль предназначен для управления настройками устройства.

## Структура:

- `example` содержит простое `electron` приложение и необходимые файлы для
  демнострации работы модуля.

## Подключение:

- ### Посмотреть пример работы пакета:
  1. Установить пакет: `npm install @neuro-city/config`;
  2. Перейти в корневую директорию модуля `common/config`;
  3. Выполнить команду `npm run example`, которая установит пакеты в обоих
     репозиториях и запустит пример
- ### Подключить пакет к проекту:
  1. Установить пакет: `npm install @neuro-city/config`;
  2. Импортировать модуль: `const config = require('neuro-city/config')`;
  3. Инициализировать модуль: `(config.init())`. Метод принимает объект с
     полями:
     - `appName` - имя проекта из package.json;
     - `mainConfigPath` - путь к локальному файлу конфигурации;
     - `defaultConfigPath` - путь к дефолтному файлу конфигурации;
     - `deviceConfigPath` - путь к конфигурации устройства

- ### Интерфейс:
  1. `init` - см. раздел подключения;
  2. `setRoot` - назначает HTML элемент, в который будет вставляться
     HTML-страница конфигурации. Принимает:
     1. HTML элемент - узел DOM-дерева, в который будет вставляться страница
        конфигурации
  3. `open` - вставляет HTML-страницу в родительский элемент. Принимает:
     1. HTML Element - узел DOM-дерева, в который будет вставляться страница
        конфигурации(необязательный параметр). Если до этого уже был назначен
        родительский элемент, то он перезапишется на новый
  4. `close` - удаляет страницу конфигурации из DOM-дерева;
  5. `isOpened` - возвращает логическое значение. Проверяет, открыта ли страница
     конфигурации;
  6. `getConfig` - возвращает копию конфигурации приложения, в котором удалены
     поля name и value(см. примечание);
  7. `getDeviceConfig` - возвращает конфиг устройства, если он есть
  8. `on` - подписка на события в работе конфига. Принимает:
     1. string - событие в процессе работы конфига. Виды событий: info, warn,
        error, open, close, ready, saved
     2. callback - коллбэк, в который передаётся описание события(в событии
        ready также второй переменной передаётся объект конфигурации)

- ### Примечания:
  1. Поле devices/camera зарезервировано и для корректной работы лучше не менять
     в нём ничего, кроме значений. Также не стоит изменять путь к нему.
  2. Чтобы изменить поля в дефолтном конфиге, нужно изменить значения поля в
     форме создания/изменения поля(доступно в девмоде)
  3. Файл конфигурации должен быть следующего вида:

         {
          	someField: {
          		name: string,
          		value: any,
          		// Опциональные поля
          	}
          }

     где:
     - name - string. Имя поля someField для удобного отображния поля на
       HTML-странице;
     - value:
       - если значение объект, то на HTML-странице он будет разделом;
       - текст/число/логическое значение - ввод значения типа
         text/number/boolean;
       - array - выбор значения из нескольких предложенных. Элементы массива
         должны быть объектами с полями name, value, chosen(boolean - выбран ли
         элемент в качестве основого);
     - также иногда могут встречаться опциональные поля (например, type или
       disabled), которые нужны для работы этого пакета

  4. Чтобы включить/выключить режим разработчика, нажмите `ctrl + shift + x`

  5. Стилизацию для конфига можно взять из `example/css/config.css`.

  6. Описание классов стилей:
     1. Страница конфига:
        1. `Config_wrapper` - обвёртка страницы конфига
        1. `Config_heading` - заголовок
        1. `Config_bottom-buttons-container` - блок внизу страницы, содержащий
           кнопки сохранить и удалить
        1. `Config_bottom-button` - кнопки внизу экрана
        1. `Config_save-button` - кнопка сохранить
        1. `Config_cancel-button` - кнопка удалить
     2. Дерево конфигурации
        1. `Config_node` - любой узел в конфиге
        1. `Config_highest-node` - самый верхний узел в конфиге
        1. `Config_input-node` - узел конфига, не являющийся разделом
     3. Классы элементов узла дерева
        1. `Config_description` - содержит имя узла, тип и кнопки изменения
           конфига
        1. `Config_node-name` - имя узла
        1. `Config_node-input-type` - тип узла(есть только узлов с текстовым или
           числовым инпутом)
        1. `Config_new-node` - добавляется полю, которого раньше не было в
           локальном конфиге и пришедшему и удалённого конфига
     4. Кнопки управления конфигом(доступны в девмоде)
        1. `Config_dev-button` - общий стиль для кнопок изменения конфига
        1. `Config_add-node-button` - добавление дочернего узла
        1. `Config_edit-node-button` - изменение текущего узла
        1. `Config_delete-node-button` - удаление текущего узла и всех дочерних
     5. Форма создания/изменения узла
        1. `Config_form` - форма создания/изменения узла
        1. `Config_form-key-input` - поле ввода ключа
        1. `Config_form-name-input` - поле ввода имени
        1. `Config_form-value-type-input` - поле ввода типа значение
        1. `Config_form-value-input` - поле ввода значения
        1. `Config_form-validation-error` - поле ошибки валидации
        1. `Config_form-submit-button` - кнопка сохранения изменений
     6. Форма создания опций
        1. `Config_options-form` - форма создания опций для селекта
        2. `Config_options-form-heading` - блок описания инпутов
        3. `Config_options-form-option-inputs` - контейнер для полей ввода
           информации о опции
        4. `Config_options-form-table-head` - Кнопка удаления опции
        5. `Config_options-form-delete-option-button` - Кнопка удаления опции
        6. `Config_options-form-add-option-button` - Кнопка создания опции
        7. полям ввода имени и значения опции являются `Config_form-name-input`
           и `Config_form-value-input` соответственно
     7. Модальное окно, появляющееся при удалении узла
        1. `Config_modal-layout` - фон модального окна, появляющегося при
           нажатии на кнопку удаления узла
        1. `Config_modal-text` - само модальное окно
        1. `Config_modal-buttons` - текст
        1. `Config_modal-submit-delete` - контейнер для кнопок
     8. Девмод
     9. `Config_dev` - класс добавляется элементу-обвертке (элемент с классом
        Config_wrapper) и даёт возможность изменять все поля конфига, а не
        только значения
     10. Остальные
         1. `Config_collapse-button` - кнопка "свернуть всё"

  - ### Changelog
    - v2.0.7:
      1. Теперь, если значение в конфиге - массив, то он будет массивом и в
         экспортном конфиге
      1. Исправлен баг, когда страница сохранялась даже, если в ней не было
         изменений
      1. Исправлен баг, при котором часть конфига с камерами не изменялась
      1. В форме создания нового поля, поле ввода значения с типом checkbox
         теперь не обязательно
    - v2.0.8:
      1. Рефакторинг кода и повышение его читаемости
      1. Теперь при выключении девмода форма создания нового поля будет также
         удаляться
    - v2.0.9:
      1. Рефакторинг кода и повышение его читаемости
      1. Валидация поля ввода шага значения
      1. Теперь подсказки о типе числа отображаются корректно
    - v2.0.10:
      1. Размер страницы конфига теперь не берётся из конфига, а присваивается в
         файле со стилями
      2. Поля, удалённые в девмоде теперь удаляются из дефолтного конфига
    - v2.0.11:
      1. Исправлен баг, из-за которого для дробных чисел определяется
         неправильный шаг
      2. Исправлены вылеты программы при чтении и обработке конфиге пустых
         конфигов
      3. Дополнены функции поиска и обработки камер
      4. Теперь при смене типа значения в форме создания нового поля с номера на
         номер или с номера на текст значение поля ввода будет сохраняться
      5. Исправлена валидация для поля ввода шага числового значения
      6. В экспортный конфиг теперь будут добавляться поля с камерами
    - v2.0.12
      1. Рефакторинг кода и повышение его читаемости
      2. Теперь в девмоде при редактировании у полей, не являющихся числовыми
         инпутами, значение в дефолтном конфиге не будет перезаписываться
      3. Доработана проверка поля, по которому определяется, будет ли скачан
         удалённый конфиг
    - v2.0.13
      1. Добавлен геттер для конфига устройства