/*
 * Decompiled with CFR 0.152.
 */
package com.dseelab.pov.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsonUtil {
    private static Gson gson = new Gson();

    public static String GsonString(Object object) {
        String gsonString = null;
        if (gson != null) {
            gsonString = gson.toJson(object);
        }
        return gsonString;
    }

    public static <T> T GsonToBean(String gsonString, Class<T> cls) {
        Object t = null;
        if (gson != null && gsonString != null) {
            t = gson.fromJson(gsonString, cls);
        }
        return (T)t;
    }

    public static <T> List<T> GsonToList(String gsonString, Class<T> cls) {
        List list = null;
        if (gson != null) {
            list = (List)gson.fromJson(gsonString, new TypeToken<List<T>>(){}.getType());
        }
        return list;
    }

    public static <T> List<T> jsonToList(String json, Class<T> cls) {
        Gson gson = new Gson();
        ArrayList<Object> list = new ArrayList<Object>();
        JsonArray array = new JsonParser().parse(json).getAsJsonArray();
        for (JsonElement elem : array) {
            list.add(gson.fromJson(elem, cls));
        }
        return list;
    }

    public static <T> List<Map<String, T>> GsonToListMaps(String gsonString) {
        List list = null;
        if (gson != null) {
            list = (List)gson.fromJson(gsonString, new TypeToken<List<Map<String, T>>>(){}.getType());
        }
        return list;
    }

    public static <T> Map<String, T> GsonToMaps(String gsonString) {
        Map map = null;
        if (gson != null) {
            map = (Map)gson.fromJson(gsonString, new TypeToken<Map<String, T>>(){}.getType());
        }
        return map;
    }
}

