/*
 * Decompiled with CFR 0.152.
 */
package com.dseelab.pov.ssdp;

import com.dseelab.pov.Constant;
import com.dseelab.pov.model.SsdpDevice;
import com.dseelab.pov.ssdp.CallBack;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SsdpClient {
    public List<SsdpDevice> addresses = new ArrayList<SsdpDevice>();
    public Set<String> deviceNames = new HashSet<String>();
    private DatagramSocket mSsdpSocket;
    private InetAddress mSsdpAddress;
    private CallBack callBack;

    public CallBack getCallBack() {
        return this.callBack;
    }

    public void setCallBack(CallBack callBack) {
        this.callBack = callBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search() {
        boolean isSuccess = false;
        try {
            if (this.mSsdpSocket == null) {
                this.mSsdpAddress = InetAddress.getByName("239.255.255.250");
                this.mSsdpSocket = new DatagramSocket(1901);
                this.mSsdpSocket.setReuseAddress(true);
            }
            DatagramPacket dgram = new DatagramPacket(Constant.SSDP_QEURY_PARAMS.getBytes(), Constant.SSDP_QEURY_PARAMS.length(), this.mSsdpAddress, 1900);
            this.mSsdpSocket.send(dgram);
            long time = System.currentTimeMillis();
            long curTime = System.currentTimeMillis();
            while (curTime - time < 5000L) {
                DatagramPacket p = new DatagramPacket(new byte[1024], 1024);
                this.mSsdpSocket.setSoTimeout(5000);
                this.mSsdpSocket.receive(p);
                String s = new String(p.getData(), 0, p.getLength());
                this.parseStr(s);
                curTime = System.currentTimeMillis();
            }
        }
        catch (UnknownHostException e) {
            isSuccess = true;
            e.printStackTrace();
        }
        catch (SocketTimeoutException e) {
            isSuccess = true;
            e.printStackTrace();
        }
        catch (IOException e) {
            isSuccess = false;
            e.printStackTrace();
        }
        finally {
            this.mSsdpSocket.close();
            if (this.callBack != null) {
                if (isSuccess) {
                    this.callBack.onSuccess(this.addresses);
                } else {
                    this.callBack.onFailed();
                }
            }
        }
    }

    private void parseStr(String str) {
        if (str.startsWith("HTTP/1.1 200 OK")) {
            String[] lines = str.split("\r\n");
            String loacation = "";
            String server = "";
            for (String line : lines) {
                if (line.startsWith("LOCATION:")) {
                    loacation = line.replace("LOCATION:", "");
                    if (this.deviceNames.add(loacation)) continue;
                    break;
                }
                if (line.startsWith("SERVER:")) {
                    server = line.replace("SERVER:", "");
                    continue;
                }
                if (!line.startsWith("ST:") || !"ST:ssdp:dseelab_client".equals(line)) continue;
                this.addresses.add(new SsdpDevice(server, loacation));
            }
        }
    }
}

