/*
 * Decompiled with CFR 0.152.
 */
package com.dseelab.pov.socket;

import com.dseelab.pov.PovException;
import com.dseelab.pov.model.BtInfo;
import com.dseelab.pov.model.DeviceState;
import com.dseelab.pov.model.FileItem;
import com.dseelab.pov.model.ShaderConfig;
import com.dseelab.pov.util.FileUtils;
import com.dseelab.pov.util.GsonUtil;
import com.dseelab.pov.util.Utils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketClient {
    private Socket mCmdSocket;
    private Socket mFileSocket;
    private String mIpAddress;
    private int mConnectCount = 0;
    private boolean isConnect;
    private String ip = "192.168.2.1";
    private String passWord;
    public boolean isLooping = false;
    public int mRepeat = 3;

    public String getIp() {
        return this.mIpAddress;
    }

    public void setIp(String ip) {
        this.mIpAddress = ip;
    }

    public boolean isConnect() {
        return this.isConnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String ip, String passWord) {
        this.ip = ip;
        this.passWord = passWord;
        this.isConnect = passWord == null || passWord.equals("");
        try {
            if (this.mCmdSocket == null || this.mCmdSocket.isClosed()) {
                this.mCmdSocket = new Socket();
                InetSocketAddress cmdAddress = new InetSocketAddress(ip, 8000);
                this.mCmdSocket.setKeepAlive(true);
                this.mCmdSocket.setSoTimeout(5000);
                this.mCmdSocket.connect(cmdAddress, 5000);
                this.isConnect = passWord == null || passWord.equals("");
                this.setIp(ip);
            }
            if (passWord != null && passWord != "") {
                DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
                dos.write(passWord.getBytes());
                dos.flush();
                byte[] bytes = new byte[1];
                InputStream is = this.mCmdSocket.getInputStream();
                is.read(bytes);
                this.isConnect = bytes[0] == 49;
            }
        }
        catch (IOException e) {
            this.mCmdSocket = null;
            if (this.isLooping && ++this.mConnectCount < this.mRepeat) {
                this.connect(ip, passWord);
            }
            this.isConnect = false;
        }
        finally {
            this.mConnectCount = 0;
        }
        return this.isConnect;
    }

    private void setConnectListener() {
        new Thread(new Runnable(){

            public void run() {
                while (SocketClient.this.isConnect) {
                    try {
                        SocketClient.this.mCmdSocket.sendUrgentData(255);
                        SocketClient.this.isConnect = true;
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        SocketClient.this.close();
                    }
                }
            }
        }).start();
    }

    public boolean connectFileSocket() {
        try {
            if (this.mFileSocket == null || this.mFileSocket.isClosed()) {
                this.mFileSocket = new Socket();
                InetSocketAddress fileAddress = new InetSocketAddress(this.getIp(), 8002);
                this.mCmdSocket.setKeepAlive(true);
                this.mFileSocket.setSoTimeout(5000);
                this.mFileSocket.connect(fileAddress, 5000);
                return this.mFileSocket.isConnected();
            }
        }
        catch (IOException e) {
            return this.connectMultipleListSocket();
        }
        return false;
    }

    private boolean connectMultipleListSocket() {
        try {
            this.mFileSocket = null;
            this.mFileSocket = new Socket();
            InetSocketAddress fileAddress = new InetSocketAddress(this.getIp(), 8003);
            this.mFileSocket.setKeepAlive(true);
            this.mFileSocket.setSoTimeout(5000);
            this.mFileSocket.connect(fileAddress, 5000);
            if (this.passWord == null || this.passWord == "") {
                return this.mFileSocket.isConnected();
            }
            DataOutputStream dos = new DataOutputStream(this.mFileSocket.getOutputStream());
            dos.write(this.passWord.getBytes());
            dos.flush();
            byte[] bytes = new byte[1];
            InputStream is = this.mFileSocket.getInputStream();
            is.read(bytes);
            return bytes[0] == 49;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.mFileSocket = null;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.mCmdSocket != null && this.isConnect) {
                this.mCmdSocket.shutdownInput();
                this.mCmdSocket.shutdownOutput();
                this.mCmdSocket.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.mCmdSocket = null;
            this.isConnect = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileSocket() {
        try {
            if (this.mFileSocket != null && this.mFileSocket.isConnected()) {
                this.mFileSocket.shutdownInput();
                this.mFileSocket.shutdownOutput();
                this.mFileSocket.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.mFileSocket = null;
        }
    }

    public boolean sendControl(byte instruction, int data) {
        try {
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return false;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getCommand(instruction, data));
            dos.flush();
            byte[] dataResult = new byte[3];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            return Utils.checkSuccess(dataResult, instruction);
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    public boolean sendControl(byte instruction, byte type, int data) {
        try {
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return false;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getCommand(instruction, type, data));
            dos.flush();
            byte[] dataResult = new byte[3];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            return Utils.checkSuccess(dataResult, instruction);
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    public int readCurrentIndex(byte instruction, byte type) {
        try {
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return -1;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getCommand(instruction, type, 0));
            dos.flush();
            byte[] dataResult = new byte[5];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            boolean result = Utils.checkSuccess(dataResult, instruction);
            if (result) {
                byte[] currentArray = new byte[]{dataResult[3], dataResult[4]};
                return (int)Utils.byteToLong(currentArray);
            }
            return -1;
        }
        catch (IOException e) {
            this.close();
            return -1;
        }
    }

    public String readCurrentName(byte instruction, byte type) {
        try {
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return "";
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getCommand(instruction, type, 0));
            dos.flush();
            byte[] dataResult = new byte[3];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            boolean result = Utils.checkSuccess(dataResult, instruction);
            if (result) {
                byte[] lengthResult = new byte[2];
                is.read(lengthResult);
                byte[] fileLength = new byte[]{lengthResult[0], lengthResult[1]};
                byte[] fileBytes = new byte[(int)Utils.byteToLong(fileLength)];
                is.read(fileBytes);
                return new String(fileBytes, "UTF-8");
            }
            return "";
        }
        catch (IOException e) {
            this.close();
            return "";
        }
    }

    public boolean sendWifi(byte instruction, String wifi, String pwd) {
        try {
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return false;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getWifiCommand(instruction, wifi, pwd));
            dos.flush();
            return true;
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    public boolean sendTiming(byte instruction, String startTime, String endTime) {
        try {
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return false;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getTimingCommand(startTime, endTime));
            dos.flush();
            byte[] dataResult = new byte[3];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            return Utils.checkSuccess(dataResult, instruction);
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    public List readPlayList(byte instruction, byte type, int date) {
        try {
            String fileJson = "";
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return null;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getCommand(instruction, type, date));
            dos.flush();
            byte[] dataResult = new byte[3];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            if (Utils.checkSuccess(dataResult, instruction)) {
                byte[] lengthResult = new byte[4];
                is.read(lengthResult);
                byte[] fileLength = new byte[]{lengthResult[0], lengthResult[1], lengthResult[2], lengthResult[3]};
                byte[] fileBytes = new byte[Utils.byteArrayToInt(fileLength)];
                is.read(fileBytes);
                fileJson = new String(fileBytes, "UTF-8");
            }
            if (type == 3) {
                return Utils.parseVideoList(fileJson);
            }
            return Utils.parsePlayList(fileJson);
        }
        catch (IOException e) {
            this.close();
            return null;
        }
    }

    public List<String> readFileList(byte instruction, byte type) {
        try {
            String fileJson = "";
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return null;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getCommand(instruction, type, 0));
            dos.flush();
            byte[] dataResult = new byte[3];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            if (Utils.checkSuccess(dataResult, instruction)) {
                byte[] lengthResult = new byte[4];
                is.read(lengthResult);
                byte[] fileLength = new byte[]{lengthResult[0], lengthResult[1], lengthResult[2], lengthResult[3]};
                byte[] fileBytes = new byte[Utils.byteArrayToInt(fileLength)];
                is.read(fileBytes);
                fileJson = new String(fileBytes, "UTF-8");
            }
            return Utils.parseFileListList(fileJson);
        }
        catch (IOException e) {
            this.close();
            return null;
        }
    }

    public List<BtInfo> readBluetoothList(byte instruction, int data) {
        try {
            String json = "";
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return null;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getCommand(instruction, data));
            dos.flush();
            byte[] dataResult = new byte[3];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            if (Utils.checkSuccess(dataResult, instruction)) {
                byte[] lengthResult = new byte[4];
                is.read(lengthResult);
                byte[] fileLength = new byte[]{lengthResult[0], lengthResult[1], lengthResult[2], lengthResult[3]};
                byte[] fileBytes = new byte[Utils.byteArrayToInt(fileLength)];
                is.read(fileBytes);
                json = new String(fileBytes, "UTF-8");
            }
            return GsonUtil.GsonToList(json, BtInfo.class);
        }
        catch (IOException e) {
            this.close();
            return null;
        }
    }

    public DeviceState readDeviceState(byte instruction, int data) {
        DeviceState deviceState = null;
        try {
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return null;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getCommand(instruction, data));
            dos.flush();
            byte[] dataResult = new byte[1024];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            if (Utils.checkSuccess(dataResult, instruction)) {
                deviceState = new DeviceState();
                deviceState.setIsRun(dataResult[3]);
                deviceState.setCloud(dataResult[4] > 6);
                deviceState.setBrightness(dataResult[5]);
                deviceState.setFilePosition((dataResult[6] << 8) + dataResult[7]);
                deviceState.setResolution(dataResult[8]);
                deviceState.setOpenTimer(dataResult[9]);
                byte[] buffer = new byte[8];
                System.arraycopy(dataResult, 10, buffer, 0, 8);
                deviceState.setResidualSpace(Utils.byteToLong(buffer));
                System.arraycopy(dataResult, 20, buffer, 0, dataResult[18]);
                deviceState.setBootTime(new String(buffer));
                System.arraycopy(dataResult, 20 + dataResult[18], buffer, 0, dataResult[19]);
                deviceState.setShutDownTime(new String(buffer));
                deviceState.setAngle(dataResult[36] << 8 + dataResult[37]);
                deviceState.setVolume(dataResult[38]);
                deviceState.setBreath(dataResult[39]);
                deviceState.setBluetooth(dataResult[40]);
                deviceState.setStartMotor(dataResult[41]);
                deviceState.setBasicVersion(dataResult[42] + "." + dataResult[43]);
                deviceState.setCoreVersion(dataResult[44] + "." + dataResult[45]);
                deviceState.setFpgaVersion(dataResult[46] + "." + dataResult[47]);
                deviceState.setServerType(dataResult[48]);
                deviceState.setSwitchInterval(dataResult[49]);
                if (dataResult[4] > 14) {
                    deviceState.setUseListIndex(dataResult[50]);
                    deviceState.setMotorSpeed(dataResult[51]);
                    deviceState.setRemoteControlSwitch(dataResult[52]);
                }
            }
        }
        catch (IOException e) {
            this.close();
        }
        return deviceState;
    }

    public ShaderConfig readShaderConfig(byte instruction, int data) {
        ShaderConfig shaderConfig = null;
        try {
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return null;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getCommand(instruction, data));
            dos.flush();
            byte[] dataResult = new byte[1024];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            if (Utils.checkSuccess(dataResult, instruction)) {
                shaderConfig = new ShaderConfig();
                shaderConfig.setHorizontalOffset(dataResult[4] & 0xFF);
                shaderConfig.setVerticalOffset(dataResult[5] & 0xFF);
                shaderConfig.setShaderMode(dataResult[6] & 0xFF);
                shaderConfig.setWhiteBackground(dataResult[7] & 0xFF);
                shaderConfig.setInner((int)Utils.byteToLong(new byte[]{dataResult[8], dataResult[9]}));
                shaderConfig.setBlur(dataResult[10] & 0xFF);
                shaderConfig.setRightAngle((int)Utils.byteToLong(new byte[]{dataResult[11], dataResult[12]}));
                shaderConfig.setRightDistance((int)Utils.byteToLong(new byte[]{dataResult[13], dataResult[14]}));
                shaderConfig.setTopAngle((int)Utils.byteToLong(new byte[]{dataResult[15], dataResult[16]}));
                shaderConfig.setTopDistance((int)Utils.byteToLong(new byte[]{dataResult[17], dataResult[18]}));
                shaderConfig.setLeftAngle((int)Utils.byteToLong(new byte[]{dataResult[19], dataResult[20]}));
                shaderConfig.setLeftDistance((int)Utils.byteToLong(new byte[]{dataResult[21], dataResult[22]}));
                shaderConfig.setBottomAngle((int)Utils.byteToLong(new byte[]{dataResult[23], dataResult[24]}));
                shaderConfig.setBottomDistance((int)Utils.byteToLong(new byte[]{dataResult[25], dataResult[26]}));
            }
        }
        catch (IOException e) {
            this.close();
        }
        return shaderConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileItem> sendFile(String[] filePath) throws IOException, PovException {
        ArrayList<FileItem> fileList = new ArrayList<FileItem>();
        try {
            if (!this.connectFileSocket()) {
                throw new PovException("Can't connect to file socket");
            }
            OutputStream os = this.mFileSocket.getOutputStream();
            InputStream is = this.mFileSocket.getInputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.write((byte)filePath.length);
            for (String path : filePath) {
                int len;
                File file = new File(path);
                if (!file.exists()) {
                    throw new PovException("Upload file not exists");
                }
                FileInputStream fis = new FileInputStream(file);
                byte[] fileName = file.getName().getBytes("UTF8");
                byte[] send = new byte[16 + fileName.length];
                long getLength = (long)(16 + fileName.length) + file.length();
                byte[] tempLength = Utils.longToByte(getLength);
                System.arraycopy(tempLength, 0, send, 0, 8);
                getLength = fileName.length;
                tempLength = Utils.longToByte(getLength);
                System.arraycopy(tempLength, 0, send, 8, 8);
                System.arraycopy(fileName, 0, send, 16, fileName.length);
                dos.write(send);
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer, 0, buffer.length)) > 0) {
                    dos.write(buffer, 0, len);
                }
                dos.flush();
                fis.close();
                byte[] data = new byte[1];
                is.read(data);
                if (data[0] != (byte)filePath.length) {
                    throw new PovException("File write failed:" + path);
                }
                fileList.add(new FileItem(file.getName(), FileUtils.getFileSize(file.length()), "1"));
            }
        }
        finally {
            this.closeFileSocket();
        }
        return fileList;
    }

    public boolean connectBluetooth(byte instruction, String btAddress) {
        try {
            if (!this.isConnect && !this.connect(this.ip, this.passWord)) {
                return false;
            }
            DataOutputStream dos = new DataOutputStream(this.mCmdSocket.getOutputStream());
            dos.write(Utils.getBtAddressCommand(btAddress));
            dos.flush();
            byte[] dataResult = new byte[3];
            InputStream is = this.mCmdSocket.getInputStream();
            is.read(dataResult);
            return Utils.checkSuccess(dataResult, instruction);
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateFileList(String listName, List<FileItem> list) {
        try {
            boolean result;
            if (listName == null || listName.equals("")) {
                result = this.connectFileSocket();
                listName = "playlist.txt";
            } else {
                result = this.connectMultipleListSocket();
            }
            if (!result) {
                boolean bl = false;
                return bl;
            }
            DataOutputStream dos = new DataOutputStream(this.mFileSocket.getOutputStream());
            String fileJson = Utils.listToString(list);
            byte[] contentBytes = fileJson.getBytes("UTF8");
            byte[] fileName = listName.getBytes("UTF8");
            byte[] send = new byte[17 + fileName.length];
            long getLength = 16 + fileName.length + contentBytes.length;
            send[0] = 1;
            byte[] tempLength = Utils.longToByte(getLength);
            System.arraycopy(tempLength, 0, send, 1, 8);
            getLength = fileName.length;
            tempLength = Utils.longToByte(getLength);
            System.arraycopy(tempLength, 0, send, 9, 8);
            System.arraycopy(fileName, 0, send, 17, fileName.length);
            dos.write(send);
            dos.write(contentBytes);
            dos.flush();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeFileSocket();
        }
        return true;
    }
}

