/*
 * Decompiled with CFR 0.152.
 */
package com.neuroair;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.neuroair.Command;
import com.neuroair.CommandHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class EventHandler
extends TextWebSocketHandler
implements WebSocketHandler {
    ObjectMapper objectMapper = new ObjectMapper();
    CommandHandler commandHandler;

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        super.afterConnectionEstablished(session);
        System.out.println("Socket Connected: " + session);
        this.commandHandler = new CommandHandler(session);
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)("you to " + (String)message.getPayload())));
        Command command = (Command)this.objectMapper.readValue((String)message.getPayload(), Command.class);
        this.commandHandler.execute(command);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        System.out.println("Socket Closed: [" + closeStatus.getCode() + "] " + closeStatus.getReason());
        super.afterConnectionClosed(session, closeStatus);
    }
}

